% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_smoothing.R
\name{smoothing}
\alias{smoothing}
\title{Smoothing}
\usage{
smoothing(n)
}
\arguments{
\item{n}{number of bins}
}
\value{
returns an object of class \code{smoothing}
}
\description{
Smoothing is a statistical technique used to reduce
the noise in a signal or a dataset by removing the high-frequency components.
The smoothing level is associated with the number of bins used.
There are alternative methods to establish the smoothing:
equal interval, equal frequency, and clustering.
}
\examples{
data(iris)
obj <- smoothing_inter(n = 2)
obj <- fit(obj, iris$Sepal.Length)
sl.bi <- transform(obj, iris$Sepal.Length)
table(sl.bi)
obj$interval

entro <- evaluate(obj, as.factor(names(sl.bi)), iris$Species)
entro$entropy
}
