% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clu_dbscan.R
\name{cluster_dbscan}
\alias{cluster_dbscan}
\title{DBSCAN}
\usage{
cluster_dbscan(minPts = 3, eps = NULL)
}
\arguments{
\item{minPts}{minimum number of points}

\item{eps}{distance value}
}
\value{
A dbscan object.
}
\description{
Creates a clusterer object that
uses the DBSCAN method
It wraps the dbscan library.
}
\examples{
# setup clustering
model <- cluster_dbscan(minPts = 3)

#load dataset
data(iris)

# build model
model <- fit(model, iris[,1:4])
clu <- cluster(model, iris[,1:4])
table(clu)

# evaluate model using external metric
eval <- evaluate(model, clu, iris$Species)
eval
}
