% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dalmatian.R
\name{dalmatian}
\alias{dalmatian}
\title{Run DGLM in \code{JAGS} via \code{rjags}}
\usage{
dalmatian(df, mean.model, variance.model, jags.model.args, coda.samples.args,
  response = NULL, rounding = FALSE, lower = NULL, upper = NULL,
  parameters = NULL, svd = TRUE, residuals = FALSE, gencode = NULL,
  drop.levels = TRUE, drop.missing = TRUE, overwrite = FALSE,
  debug = FALSE, saveJAGSinput = NULL)
}
\arguments{
\item{df}{Data frame containing the response and predictor values for each individual. (data.frame)}

\item{mean.model}{Model list specifying the structure of the mean. (list)}

\item{variance.model}{Model list specifying the structure of the variance. (list)}

\item{jags.model.args}{List containing named arguments of \code{jags.model}. (list)}

\item{coda.samples.args}{List containing named arguments of \code{coda.samples}. (list)}

\item{response}{Name of variable in the data frame representing the response. (character)}

\item{rounding}{Specifies that response has been rounded if TRUE. (logical)}

\item{lower}{Name of variable in the data frame representing the lower bound on the response if rounded. (character)}

\item{upper}{Name of variable in the data frame representing the upper bound on the response if rounded. (character)}

\item{parameters}{Names of parameters to monitor. If NULL then default values are selected. (character)}

\item{svd}{Compute Singular Variable Decomposition of model matrices to improve convergence. (logical)}

\item{residuals}{If TRUE then compute residuals in output. (logical)}

\item{gencode}{If TRUE then generate code potentially overwriting existing model file. By default generate code if the file does not exist and prompt user if it does. (logical)}

\item{drop.levels}{If TRUE then drop unused levels from all factors in df. (logical)}

\item{drop.missing}{If TRUE then remove records with missing response variable. (logical)}

\item{overwrite}{If TRUE then overwrite existing JAGS files (non-interactive sessions only). (logical)}

\item{debug}{If TRUE then enter debug model. (logical)}

\item{saveJAGSinput}{Directory to which jags.model input is saved prior to calling \code{jags.model()}. This is useful for debugging. No files saved if NULL. (character)}
}
\value{
samples (mcmc.list)
}
\description{
The primary function which automates the running of \code{JAGS}.
}
\details{
The primary function in the package, dalmatian automates the generation of code, data, and initial values. These are then passed as arguments to function from the \code{rjags} package which automates the generation of samplse from the posterior.
}
\examples{

\dontrun{
## Load pied flycatcher data
data(pied_flycatchers_1)

## Create variables bounding the true load
pfdata$lower=ifelse(pfdata$load==0,log(.001),log(pfdata$load-.049))
pfdata$upper=log(pfdata$load+.05)
## Mean model
mymean=list(fixed=list(name="alpha",
                      formula=~ log(IVI) + broodsize + sex,
                      priors=list(c("dnorm",0,.001))))

## Variance model
myvar=list(fixed=list(name="psi",
                      link="log",
                      formula=~broodsize + sex,
                      priors=list(c("dnorm",0,.001))))

## Set working directory
## By default uses a system temp directory. You probably want to change this.
workingDir <- tempdir()

## Define list of arguments for jags.model()
jm.args <- list(file=file.path(workingDir,"pied_flycatcher_1_jags.R"),n.adapt=1000)

## Define list of arguments for coda.samples()
cs.args <- list(n.iter=5000)

## Run the model using dalmatian
pfresults <- dalmatian(df=pfdata,
                         mean.model=mymean,
                         variance.model=myvar,
                         jags.model.args=jm.args,
                         coda.samples.args=cs.args,
                         rounding=TRUE,
                         lower="lower",
                         upper="upper",
                         debug=FALSE)
}                          
}
\author{
Simon Bonner
}
