% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dagitty.r
\name{plotLocalTestResults}
\alias{plotLocalTestResults}
\title{Plot Results of Local Tests}
\usage{
plotLocalTestResults(x, xlab = "test statistic (95\% CI)", xlim = c(min(x[,
  c(4, 5)]), max(x[, c(4, 5)])), ...)
}
\arguments{
\item{x}{data frame; results of the local tests as returned by 
\link{localTests}.}

\item{xlab}{X axis label.}

\item{xlim}{numerical vector with 2 elements; range of X axis.}

\item{...}{further arguments to be passed on to \code{\link{plot}}.}
}
\description{
Generates a summary plot of the results of local tests
(see \link{localTests}). For each test, a test statistic and
the confidence interval are shown.
}
\examples{
d <- simulateSEM("dag{X->{U1 M2}->Y U1->M1}",.6,.6)
par(mar=c(2,8,1,1)) # so we can see the test names
plotLocalTestResults(localTests( "dag{ X -> {M1 M2} -> Y }", d, "cis" ))

}

