% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_stats.R, R/formatting_stats_dm.R
\name{calc_stats}
\alias{calc_stats}
\alias{calc_stats.data.frame}
\alias{calc_stats.drift_dm}
\alias{calc_stats.fits_ids_dm}
\alias{print.stats_dm}
\alias{print.stats_dm_list}
\title{Calculate Statistics}
\usage{
calc_stats(object, type, ...)

\method{calc_stats}{data.frame}(
  object,
  type,
  ...,
  conds = NULL,
  verbose = 0,
  average = FALSE,
  split_by_ID = TRUE,
  b_coding = NULL
)

\method{calc_stats}{drift_dm}(object, type, ..., conds = NULL)

\method{calc_stats}{fits_ids_dm}(object, type, ..., verbose = 1, average = FALSE)

\method{print}{stats_dm}(
  x,
  ...,
  round_digits = drift_dm_default_rounding(),
  print_rows = 10,
  some = FALSE,
  show_header = TRUE,
  show_note = TRUE
)

\method{print}{stats_dm_list}(x, ...)
}
\arguments{
\item{object}{an object for which statistics are calculated. This can be a
\link{data.frame} of observed data, a \link{drift_dm} object, or a
\code{fits_ids_dm} object (see \link{estimate_model_ids}).}

\item{type}{a character vector, specifying the statistics to calculate.
Supported values include \code{"cafs"}, \code{"quantiles"}, \code{"delta_funs"}, and
\code{"fit_stats"}.}

\item{...}{additional arguments passed to the respective method and the
underlying calculation functions (see Details for mandatory arguments).}

\item{conds}{optional character vector specifying conditions to include.
Conditions must match those found in the \code{object}.}

\item{verbose}{integer, indicating if information about the progress
should be displayed. 0 -> no information, 1 -> a progress bar. Default is 0.}

\item{average}{logical. If \code{TRUE}, averages the statistics across individuals
where applicable. Default is \code{FALSE}.}

\item{split_by_ID}{logical. If \code{TRUE}, statistics are calculated separately
for each individual ID in \code{object} (when \code{object} is a \link{data.frame}). Default
is \code{TRUE}.}

\item{b_coding}{a list for boundary coding (see \link{b_coding}). Only
relevant when \code{object} is a \link{data.frame}. For other \code{object} types, the
\code{b_coding} of the \code{Object} is used.}

\item{x}{an object of type \code{stats_dm} or \code{stats_dm_list}, as returned by
the function \code{calc_stats()}.}

\item{round_digits}{integer, controls the number of digits shown.
Default is 3.}

\item{print_rows}{integer, controls the number of rows shown.}

\item{some}{logical. If \code{TRUE}, a subset of randomly sampled rows is shown.}

\item{show_header}{logical. If \code{TRUE}, a header specifying the type of
statistic will be displayed.}

\item{show_note}{logical. If \code{TRUE}, a footnote  is displayed indicating
that the underlying \link{data.frame} can be accessed as usual.}
}
\value{
If \code{type} is a single character string, then a subclass of \link{data.frame} is
returned, containing the respective statistic. Objects of type \code{sum_dist}
will have an additional attribute storing the boundary encoding (see also
\link{b_coding}). The reason for returning subclasses of \link{data.frame} is
to provide custom \code{plot()} methods (e.g., \link{plot.cafs}). To get rid
of the subclass label and additional attributes (i.e., to get just the plain
underlying \link{data.frame}, users can use \code{\link[=unpack_obj]{unpack_obj()}}).

If \code{type} contains multiple character strings (i.e., is a character vector) a
subclass of \link{list} with the calculated statistics is returned. The list will
be of type \code{stats_dm_list} (to easily create multiple panels using the
respective \code{\link[=plot.stats_dm_list]{plot.stats_dm_list()}} method).

The print methods \code{print.stats_dm()} and \code{print.stats_dm_list()} each
invisibly return the supplied object \code{x}.
}
\description{
\code{calc_stats} provides an interface for calculating statistics/metrics on
model predictions and/or observed data. Supported statistics include
Conditional Accuracy Functions (CAFs), Quantiles, Delta Functions, and fit
statistics. Results can be aggregated across individuals.
}
\details{
\code{calc_stats} is a generic function to handle the calculation of different
statistics/metrics for the supported object types. Per default, it returns
the requested statistics/metrics.
\subsection{Conditional Accuracy Function (CAFs)}{

CAFs are a way to quantify response accuracy against speed. To calculate
CAFs, RTs (whether correct or incorrect) are first binned and then the
percent correct responses per bin is calculated.

When calculating model-based CAFs, a joint CDF combining both the pdf
of correct and incorrect responses is calculated. Afterwards, this CDF
is separated into even-spaced segments and the contribution of
the pdf associated with a correct response relative to the joint CDF is
calculated.

The number of bins can be controlled by passing the argument \code{n_bins}.
The default is 5.
}

\subsection{Quantiles}{

For observed response times, the function \link[stats:quantile]{stats::quantile} is used with
default settings.

Which quantiles are calcuated can be controlled by providing the
probabilites, \code{probs}, with values in \eqn{[0, 1]}. Default is
\code{seq(0.1, 0.9, 0.1)}.
}

\subsection{Delta Functions}{

Delta functions calculate the difference between quantiles
of two conditions against their mean:
\itemize{
\item \eqn{Delta_i = Q_{i,j} - Q_{i,k}}
\item \eqn{Avg_i = 0.5 \cdot Q_{i,j} + 0.5 \cdot Q_{i,k}}
}

With i indicating a quantile, and j and k two conditions.

To calculate delta functions, users have to specify:
\itemize{
\item \code{minuends}: character vector, specifying condition(s) j. Must be in
\code{conds(drift_dm_obj)}.
\item \code{subtrahends}: character vector, specifying condition(s) k. Must be in
\code{conds(drift_dm_obj)}
\item \code{dvs}: character, indicating which quantile columns to use.
Default is "Quant_<u_label>". If multiple dvs are provided,
then minuends and subtrahends must have the same length,
and matching occurs pairwise. In this case, if only one
minuend/subtrahend is specified, minuend and subtrahend are recycled to
the necessary length.
}
}

\subsection{Fit Statistics}{

Calculates the Akaike and Bayesian Information Criteria (AIC and BIC). Users
can provide a \code{k} argument to penalize the AIC statistic (see \link[stats:AIC]{stats::AIC}
and \link{AIC.fits_ids_dm})
}
}
\examples{
# Example 1: Calculate CAFs and Quantiles from a model ---------------------
# get a model for demonstration purpose
a_model <- ssp_dm(dx = .0025, dt = .0025, t_max = 2)
# and then calculate cafs and quantiles
some_stats <- calc_stats(a_model, type = c("cafs", "quantiles"))
print(some_stats)

# Example 2: Calculate a Delta Function from a data.frame ------------------
# get a data set for demonstration purpose
some_data <- ulrich_simon_data
conds(some_data) # relevant for minuends and subtrahends
some_stats <- calc_stats(
  a_model,
  type = "delta_funs",
  minuends = "incomp",
  subtrahends = "comp"
)
print(some_stats, print_rows = 5)


# Example 3: Calculate Quantiles from a fits_ids_dm object -----------------
# get an auxiliary fits_ids_dm object
all_fits <- get_example_fits_ids()
some_stats <- calc_stats(all_fits, type = "quantiles")
print(some_stats, print_rows = 5) # note the ID column

# one can also request that the statistics are averaged across individuals
print(
  calc_stats(all_fits, type = "quantiles", average = TRUE)
)

}
