% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_dm.R
\name{get_default_functions}
\alias{get_default_functions}
\title{Get default/fall back component functions}
\usage{
get_default_functions(
  mu_fun = NULL,
  mu_int_fun = NULL,
  x_fun = NULL,
  b_fun = NULL,
  dt_b_fun = NULL,
  nt_fun = NULL
)
}
\arguments{
\item{mu_fun}{drift rate function}

\item{mu_int_fun}{integral drift rate function}

\item{x_fun}{starting point function}

\item{b_fun}{boundary function}

\item{dt_b_fun}{derivative of boundary function}

\item{nt_fun}{non-decision time function}
}
\value{
a list of \code{mu_fun}, \code{mu_int_fun}, \code{x_fun}, \code{b_fun}, \code{dt_b_fun}, and
\code{nt_fun}, with either the supplied component functions
or the added/filled in default component functions (if an argument is NULL).
}
\description{
If arguments are provided that are not NULL, the respective argument is
simply returned. If it is NULL, then a default/fall back component function
is returned for the respective component. This function is called to fill up
non-specified component functions when calling \code{\link[=drift_dm]{drift_dm()}}.
}
\details{
defaults...
\itemize{
\item mu_fun -> constant drift rate of 3 (i.e., vector of 0s)
\item mu_int_fun -> constant drift rate of 3 (i.e., vector of 3 times t_vec)
\item x_fun -> dirac delta on zero \code{\link[=x_dirac_0]{x_dirac_0()}}
\item b_fun -> constant boundary of 0.5 (i.e., vector of 0.5s)
\item dt_b_fun -> derivate of constant boundary (i.e., vector of 0s).
\code{\link[=dt_b_constant]{dt_b_constant()}}
\item nt_fun -> constant non-decision time of 0.3 (i.e., vector for dirac delta
on 0.5).
}
}
\keyword{internal}
