% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objClass.R
\name{constraintL2}
\alias{constraintL2}
\title{Soft L2 constraint on parameters}
\usage{
constraintL2(mu, sigma = 1, attr.name = "prior", condition = NULL)
}
\arguments{
\item{mu}{named numeric, the prior values}

\item{sigma}{named numeric of length of mu or numeric of length one.}

\item{attr.name}{character. The constraint value is additionally returned in an 
attributed with this name}

\item{condition}{character, the condition for which the constraint should apply. If
\code{NULL}, applies to any condition.}
}
\value{
object of class \code{objfn}
}
\description{
Soft L2 constraint on parameters
}
\details{
Computes the constraint value 
\deqn{\left(\frac{p-\mu}{\sigma}\right)^2}{(p-mu)^2/sigma^2}
and its derivatives with respect to p.
}
\examples{
mu <- c(A = 0, B = 0)
sigma <- c(A = 0.1, B = 1)
myfn <- constraintL2(mu, sigma)
myfn(pars = c(A = 1, B = -1))
}
\seealso{
\link{wrss}
}

