% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/toolsBeni.R
\name{variableTransformation}
\alias{variableTransformation}
\title{Do a variable transformation in the ODE}
\usage{
variableTransformation(observables, f = NULL, dynvar = NULL, stoi = NULL,
  flows = NULL, conserved = TRUE)
}
\arguments{
\item{observables}{Named character vector. The names are the new variable names, the vector
entries define the new variables in terms of the old ones.}

\item{f}{An object of class \code{eqnList}, see \link{generateEquations}.}

\item{dynvar}{Character vector with the old variable names}

\item{stoi}{The stoichiometric matrix}

\item{flows}{Character vector with the rate expressions}

\item{conserved}{Logical. If true, the conserved quantities derived from the
stoichiometric matrix are automatically used for extending the vector of observables. See details.}
}
\value{
Named character vector with the ODE expressed in the new variables. In addition,
attributes "variables" (the variable transformation) and "inverse" (the inverse transformation)
are returned.
}
\description{
Do a variable transformation in the ODE
}
\details{
Usually, the function is called by either using the \code{f} argument and leaving the
other arguments \code{NULL} or by leaving \code{f} NULL and defining the ODE by the arguments
\code{dynvar}, \code{stoi} and \code{flows}.
The \code{observables} vector can have less entries than the vector \code{dynvar}. In this
case, the observables are automatically extended by old variables to generate a full rank
variable transformation. If \code{conserved} is \code{TRUE}, the conserved quantities are
preferentially used to extend the observables vector. Consequently, the transformed equations
will return a certain number of zero-equation.
}

