% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StoragehubManager.R
\docType{class}
\name{StoragehubManager}
\alias{StoragehubManager}
\title{StoragehubManager}
\value{
Object of \code{\link{R6Class}} for modelling a D4Science StoragehubManager
}
\description{
StoragehubManager

StoragehubManager
}
\note{
Main user class to be used with \pkg{d4storagehub4R}

Deprecated
}
\examples{
\dontrun{
  manager <- StoragehubManager$new(
    token = "<your token>",
    logger = "DEBUG"
  )
}

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{manager}
\keyword{storagehub}
\section{Super class}{
\code{\link[d4storagehub4R:d4storagehub4RLogger]{d4storagehub4R::d4storagehub4RLogger}} -> \code{StoragehubManager}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-StoragehubManager-new}{\code{StoragehubManager$new()}}
\item \href{#method-StoragehubManager-getToken}{\code{StoragehubManager$getToken()}}
\item \href{#method-StoragehubManager-getUserProfile}{\code{StoragehubManager$getUserProfile()}}
\item \href{#method-StoragehubManager-getUserWorkspace}{\code{StoragehubManager$getUserWorkspace()}}
\item \href{#method-StoragehubManager-fetchWSEndpoint}{\code{StoragehubManager$fetchWSEndpoint()}}
\item \href{#method-StoragehubManager-fetchUserProfile}{\code{StoragehubManager$fetchUserProfile()}}
\item \href{#method-StoragehubManager-getWSRoot}{\code{StoragehubManager$getWSRoot()}}
\item \href{#method-StoragehubManager-getWSRootID}{\code{StoragehubManager$getWSRootID()}}
\item \href{#method-StoragehubManager-getWSItem}{\code{StoragehubManager$getWSItem()}}
\item \href{#method-StoragehubManager-getWSItemID}{\code{StoragehubManager$getWSItemID()}}
\item \href{#method-StoragehubManager-getWSVREFolder}{\code{StoragehubManager$getWSVREFolder()}}
\item \href{#method-StoragehubManager-getWSVREFolderID}{\code{StoragehubManager$getWSVREFolderID()}}
\item \href{#method-StoragehubManager-listWSItems}{\code{StoragehubManager$listWSItems()}}
\item \href{#method-StoragehubManager-listWSItemsByPath}{\code{StoragehubManager$listWSItemsByPath()}}
\item \href{#method-StoragehubManager-searchWSItem}{\code{StoragehubManager$searchWSItem()}}
\item \href{#method-StoragehubManager-searchWSItemID}{\code{StoragehubManager$searchWSItemID()}}
\item \href{#method-StoragehubManager-createFolder}{\code{StoragehubManager$createFolder()}}
\item \href{#method-StoragehubManager-uploadFile}{\code{StoragehubManager$uploadFile()}}
\item \href{#method-StoragehubManager-deleteItem}{\code{StoragehubManager$deleteItem()}}
\item \href{#method-StoragehubManager-shareItem}{\code{StoragehubManager$shareItem()}}
\item \href{#method-StoragehubManager-unshareItem}{\code{StoragehubManager$unshareItem()}}
\item \href{#method-StoragehubManager-downloadItem}{\code{StoragehubManager$downloadItem()}}
\item \href{#method-StoragehubManager-downloadItemByPath}{\code{StoragehubManager$downloadItemByPath()}}
\item \href{#method-StoragehubManager-getPublicFileLinkByID}{\code{StoragehubManager$getPublicFileLinkByID()}}
\item \href{#method-StoragehubManager-getPublicFileLink}{\code{StoragehubManager$getPublicFileLink()}}
\item \href{#method-StoragehubManager-clone}{\code{StoragehubManager$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="d4storagehub4R" data-topic="d4storagehub4RLogger" data-id="ERROR"><a href='../../d4storagehub4R/html/d4storagehub4RLogger.html#method-d4storagehub4RLogger-ERROR'><code>d4storagehub4R::d4storagehub4RLogger$ERROR()</code></a></span></li>
<li><span class="pkg-link" data-pkg="d4storagehub4R" data-topic="d4storagehub4RLogger" data-id="INFO"><a href='../../d4storagehub4R/html/d4storagehub4RLogger.html#method-d4storagehub4RLogger-INFO'><code>d4storagehub4R::d4storagehub4RLogger$INFO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="d4storagehub4R" data-topic="d4storagehub4RLogger" data-id="WARN"><a href='../../d4storagehub4R/html/d4storagehub4RLogger.html#method-d4storagehub4RLogger-WARN'><code>d4storagehub4R::d4storagehub4RLogger$WARN()</code></a></span></li>
<li><span class="pkg-link" data-pkg="d4storagehub4R" data-topic="d4storagehub4RLogger" data-id="getClass"><a href='../../d4storagehub4R/html/d4storagehub4RLogger.html#method-d4storagehub4RLogger-getClass'><code>d4storagehub4R::d4storagehub4RLogger$getClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="d4storagehub4R" data-topic="d4storagehub4RLogger" data-id="getClassName"><a href='../../d4storagehub4R/html/d4storagehub4RLogger.html#method-d4storagehub4RLogger-getClassName'><code>d4storagehub4R::d4storagehub4RLogger$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="d4storagehub4R" data-topic="d4storagehub4RLogger" data-id="logger"><a href='../../d4storagehub4R/html/d4storagehub4RLogger.html#method-d4storagehub4RLogger-logger'><code>d4storagehub4R::d4storagehub4RLogger$logger()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StoragehubManager-new"></a>}}
\if{latex}{\out{\hypertarget{method-StoragehubManager-new}{}}}
\subsection{Method \code{new()}}{
Method is used to instantiate the \link{StoragehubManager}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StoragehubManager$new(
  token,
  token_type = "gcube",
  logger = NULL,
  keyring_backend = "env"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{token}}{user access token}

\item{\code{token_type}}{token type, either 'gcube' (default) or 'jwt'}

\item{\code{logger}}{logger can be either NULL, "INFO" (with minimum logs), or "DEBUG" (for complete 
curl http calls logs)}

\item{\code{keyring_backend}}{keyring backend to use.it can be set to use a different backend for storing 
the D4science gcube token with \pkg{keyring} (Default value is 'env').}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StoragehubManager-getToken"></a>}}
\if{latex}{\out{\hypertarget{method-StoragehubManager-getToken}{}}}
\subsection{Method \code{getToken()}}{
Get token
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StoragehubManager$getToken()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
the user access token
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StoragehubManager-getUserProfile"></a>}}
\if{latex}{\out{\hypertarget{method-StoragehubManager-getUserProfile}{}}}
\subsection{Method \code{getUserProfile()}}{
Get user profile
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StoragehubManager$getUserProfile()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
the user profile
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StoragehubManager-getUserWorkspace"></a>}}
\if{latex}{\out{\hypertarget{method-StoragehubManager-getUserWorkspace}{}}}
\subsection{Method \code{getUserWorkspace()}}{
Get user workspace
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StoragehubManager$getUserWorkspace()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
the user workspace root path
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StoragehubManager-fetchWSEndpoint"></a>}}
\if{latex}{\out{\hypertarget{method-StoragehubManager-fetchWSEndpoint}{}}}
\subsection{Method \code{fetchWSEndpoint()}}{
Fetches the workspace endpoint from the D4Science ICProxy service
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StoragehubManager$fetchWSEndpoint()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StoragehubManager-fetchUserProfile"></a>}}
\if{latex}{\out{\hypertarget{method-StoragehubManager-fetchUserProfile}{}}}
\subsection{Method \code{fetchUserProfile()}}{
Fetches the user profile
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StoragehubManager$fetchUserProfile()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StoragehubManager-getWSRoot"></a>}}
\if{latex}{\out{\hypertarget{method-StoragehubManager-getWSRoot}{}}}
\subsection{Method \code{getWSRoot()}}{
Get workspace root
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StoragehubManager$getWSRoot()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
the workspace root, as \code{list}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StoragehubManager-getWSRootID"></a>}}
\if{latex}{\out{\hypertarget{method-StoragehubManager-getWSRootID}{}}}
\subsection{Method \code{getWSRootID()}}{
Get workspace root ID
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StoragehubManager$getWSRootID()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
the workspace root ID, as \code{character}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StoragehubManager-getWSItem"></a>}}
\if{latex}{\out{\hypertarget{method-StoragehubManager-getWSItem}{}}}
\subsection{Method \code{getWSItem()}}{
Get workspace item given a \code{itemPath} in a parent folder
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StoragehubManager$getWSItem(
  parentFolderID = NULL,
  itemPath,
  showHidden = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parentFolderID}}{parent folder ID}

\item{\code{itemPath}}{item path}

\item{\code{showHidden}}{show hidden files}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the workspace item, \code{NULL} if no workspace item existing
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StoragehubManager-getWSItemID"></a>}}
\if{latex}{\out{\hypertarget{method-StoragehubManager-getWSItemID}{}}}
\subsection{Method \code{getWSItemID()}}{
Get workspace item ID given a \code{itemPath} in a parent folder
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StoragehubManager$getWSItemID(
  parentFolderID = NULL,
  itemPath,
  showHidden = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parentFolderID}}{parent folder ID}

\item{\code{itemPath}}{item path}

\item{\code{showHidden}}{show hidden files}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the workspace item ID, \code{NULL} if no workspace item existing
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StoragehubManager-getWSVREFolder"></a>}}
\if{latex}{\out{\hypertarget{method-StoragehubManager-getWSVREFolder}{}}}
\subsection{Method \code{getWSVREFolder()}}{
Get VRE Folder
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StoragehubManager$getWSVREFolder()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
the VRE folder, as \code{list}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StoragehubManager-getWSVREFolderID"></a>}}
\if{latex}{\out{\hypertarget{method-StoragehubManager-getWSVREFolderID}{}}}
\subsection{Method \code{getWSVREFolderID()}}{
Get VRE Folder ID
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StoragehubManager$getWSVREFolderID()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
the VRE folder ID, as \code{character}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StoragehubManager-listWSItems"></a>}}
\if{latex}{\out{\hypertarget{method-StoragehubManager-listWSItems}{}}}
\subsection{Method \code{listWSItems()}}{
Lists workspace items given a parentFolder ID
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StoragehubManager$listWSItems(parentFolderID = NULL, showHidden = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parentFolderID}}{parent folder ID}

\item{\code{showHidden}}{show hidden files}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an object of class \code{data.frame}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StoragehubManager-listWSItemsByPath"></a>}}
\if{latex}{\out{\hypertarget{method-StoragehubManager-listWSItemsByPath}{}}}
\subsection{Method \code{listWSItemsByPath()}}{
Lists workspace items given a folder path
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StoragehubManager$listWSItemsByPath(folderPath, showHidden = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{folderPath}}{folder path where to list items}

\item{\code{showHidden}}{show hidden files}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an object of class \code{data.frame}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StoragehubManager-searchWSItem"></a>}}
\if{latex}{\out{\hypertarget{method-StoragehubManager-searchWSItem}{}}}
\subsection{Method \code{searchWSItem()}}{
Searches for a workspace item given a item path
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StoragehubManager$searchWSItem(
  itemPath,
  includeVreFolder = TRUE,
  showHidden = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{itemPath}}{path of the item}

\item{\code{includeVreFolder}}{search also in VRE folder}

\item{\code{showHidden}}{show hidden files}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the item, \code{NULL} if nothing found
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StoragehubManager-searchWSItemID"></a>}}
\if{latex}{\out{\hypertarget{method-StoragehubManager-searchWSItemID}{}}}
\subsection{Method \code{searchWSItemID()}}{
Searches for a workspace item ID given a item path
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StoragehubManager$searchWSItemID(
  itemPath,
  includeVreFolder = TRUE,
  showHidden = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{itemPath}}{path of the item}

\item{\code{includeVreFolder}}{search also in VRE folder}

\item{\code{showHidden}}{show hidden files}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the item, \code{NULL} if nothing found
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StoragehubManager-createFolder"></a>}}
\if{latex}{\out{\hypertarget{method-StoragehubManager-createFolder}{}}}
\subsection{Method \code{createFolder()}}{
Creates a folder, given a folder path, a folder name/description. By default \code{recursive = TRUE} meaning 
   that a folder path matching nested folders will trigger all nested folders. Setting \code{recursive = FALSE}, the
   folder creation will work only if the folder path matches an existing folder. The \code{hidden} (default 
   \code{FALSE}) argument can be used to set hidden folders on the workspace. Using \code{folderID}, \code{recursive} will be
   set to \code{FALSE}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StoragehubManager$createFolder(
  folderPath = NULL,
  folderID = NULL,
  name,
  description = "",
  hidden = FALSE,
  recursive = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{folderPath}}{parent folder path where to create the folder}

\item{\code{folderID}}{parent folder ID where to create the folder}

\item{\code{name}}{name of the folder}

\item{\code{description}}{description of the folder}

\item{\code{hidden}}{hidden, default is \code{FALSE}}

\item{\code{recursive}}{recursive, default is \code{TRUE}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the ID of the created folder
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StoragehubManager-uploadFile"></a>}}
\if{latex}{\out{\hypertarget{method-StoragehubManager-uploadFile}{}}}
\subsection{Method \code{uploadFile()}}{
Uploads a file to a folder (given a folder path). The argument \code{description} can be used to further describe the
   file to upload. The argument \code{archive} (default = FALSE) indicates the type of item (FILE or ARCHIVE) to be uploaded.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StoragehubManager$uploadFile(
  folderPath = NULL,
  folderID = NULL,
  file,
  description = basename(file),
  archive = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{folderPath}}{folder path where to upload the file}

\item{\code{folderID}}{folder ID where to upload the file}

\item{\code{file}}{file to upload}

\item{\code{description}}{file description, default would be the file basename}

\item{\code{archive}}{archive, default is \code{FALSE}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the ID of the uploaded file
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StoragehubManager-deleteItem"></a>}}
\if{latex}{\out{\hypertarget{method-StoragehubManager-deleteItem}{}}}
\subsection{Method \code{deleteItem()}}{
Deletes an item given its path on the workspace
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StoragehubManager$deleteItem(itemPath, force = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{itemPath}}{item path}

\item{\code{force}}{whether to force deletion, default is \code{FALSE}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StoragehubManager-shareItem"></a>}}
\if{latex}{\out{\hypertarget{method-StoragehubManager-shareItem}{}}}
\subsection{Method \code{shareItem()}}{
Shares an item with users
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StoragehubManager$shareItem(itemPath, defaultAccessType, users)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{itemPath}}{item path}

\item{\code{defaultAccessType}}{access type to use for sharing, among 'WRITE_ALL', 'WRITE_OWNER', 'READ_ONLY', 'ADMINISTRATOR'}

\item{\code{users}}{one or more user names with whom the item has to be shared}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if shared, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StoragehubManager-unshareItem"></a>}}
\if{latex}{\out{\hypertarget{method-StoragehubManager-unshareItem}{}}}
\subsection{Method \code{unshareItem()}}{
unshare an item
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StoragehubManager$unshareItem(itemPath, users)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{itemPath}}{item path}

\item{\code{users}}{users}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if unshared, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StoragehubManager-downloadItem"></a>}}
\if{latex}{\out{\hypertarget{method-StoragehubManager-downloadItem}{}}}
\subsection{Method \code{downloadItem()}}{
Download item
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StoragehubManager$downloadItem(item = NULL, wd = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{item}}{item}

\item{\code{wd}}{working directory where to download the item}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StoragehubManager-downloadItemByPath"></a>}}
\if{latex}{\out{\hypertarget{method-StoragehubManager-downloadItemByPath}{}}}
\subsection{Method \code{downloadItemByPath()}}{
Download item by path
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StoragehubManager$downloadItemByPath(path, wd = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{path}

\item{\code{wd}}{working directory where to download the item}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StoragehubManager-getPublicFileLinkByID"></a>}}
\if{latex}{\out{\hypertarget{method-StoragehubManager-getPublicFileLinkByID}{}}}
\subsection{Method \code{getPublicFileLinkByID()}}{
Get public file link by ID
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StoragehubManager$getPublicFileLinkByID(pathID)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pathID}}{file item ID}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the public file URL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StoragehubManager-getPublicFileLink"></a>}}
\if{latex}{\out{\hypertarget{method-StoragehubManager-getPublicFileLink}{}}}
\subsection{Method \code{getPublicFileLink()}}{
Get public file link
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StoragehubManager$getPublicFileLink(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{file path}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the public file URL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StoragehubManager-clone"></a>}}
\if{latex}{\out{\hypertarget{method-StoragehubManager-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StoragehubManager$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
