% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{po_geomap}
\alias{po_geomap}
\title{Geomap}
\usage{
po_geomap(d3po, ..., data = NULL, inherit_daes = TRUE, limits = NULL)
}
\arguments{
\item{d3po}{Either the output of \code{\link[=d3po]{d3po()}} or \code{\link[=d3po_proxy]{d3po_proxy()}}.}

\item{...}{Aesthetics, see \code{\link[=daes]{daes()}}.}

\item{data}{Any dataset to use for plot, overrides data passed
to \code{\link[=d3po]{d3po()}}.}

\item{inherit_daes}{Whether to inherit aesthetics previous specified.}

\item{limits}{A numeric vector of length 2 specifying the minimum and maximum values for the color scale.}
}
\value{
an 'htmlwidgets' object with the desired interactive plot
}
\description{
Plot a geomap using sf spatial objects
}
\examples{
if (interactive()) {
  world <- d3po::national

  # Fix geometries that cross the antimeridian (date line) to avoid horizontal lines
  # This affects Russia, Fiji, and other countries spanning the 180° meridian
  world$geometry <- sf::st_wrap_dateline(world$geometry, options = c("WRAPDATELINE=YES"))

  total_trade <- d3po::trade[
    d3po::trade$year == 2023L,
    c("reporter", "reporter_continent", "trade")
  ]
  total_trade <- aggregate(trade ~ reporter, data = total_trade, FUN = sum)
  colnames(total_trade) <- c("country", "trade")

  world <- merge(
    world,
    total_trade,
    by = "country",
    all.x = TRUE,
    all.y = FALSE
  )

  my_pal <- tintin::tintin_pal(option = "The Calculus Affair")(7)

  names(my_pal) <- c(
    "Africa", "Antarctica", "Asia",
    "Europe", "North America", "Oceania", "South America"
  )

  d3po(world, width = 800, height = 600) \%>\%
    po_geomap(daes(group = country, size = trade, color = my_pal, tooltip = country)) \%>\%
    po_labels(title = "Trade Volume by Country in 2023")
}
}
