% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_cyclomort.R
\name{fit_cyclomort}
\alias{fit_cyclomort}
\title{Estimate periodic hazard function.}
\usage{
fit_cyclomort(
  x,
  inits = NULL,
  n.seasons = 2,
  method = "L-BFGS-B",
  period = NULL
)
}
\arguments{
\item{x}{a cycloSurv object recording start and end times as well as status 
(dead/censored) and the length of one full period}

\item{inits}{set of initial guesses; a named vector or list with values for 
"peak" and "duration". Leaving some or all of these parameters as NULL will 
trigger the automatic selection of an initial guess.}

\item{n.seasons}{number of seasons to fit model to}

\item{method}{method for optim call}

\item{period}{expected periodicity of survival data. Can be passed in with 
cycloSurv input parameter}
}
\value{
a cmfit object containing parameter estimates for peaks, durations, 
and weights for each season
}
\description{
This function takes time-to-event data formatted as a \code{cycloSurv} object 
and estimates an underlying hazard function for a given number of seasons.
}
\examples{
# Simulate data
T.morts1 <- simulate_cycloSurv(1000, period = 365, 
                             meanhazard = 0.3 / 365, 
                             peaks = c(0.25 * 365, 0.75 * 365), 
                             durations = c(0.3 * 365, 0.1 * 365), 
                             weights = c(0.7,0.3), 
                             plotme = FALSE)

# Estimate simulated data
fits <- fit_cyclomort(T.morts1, n.seasons = 2)
fits

# Plot results
plot(fits, nreps = 1000, monthlabs = TRUE)
# NB: `nreps` is for the bootstrap of the confidence interval 
# The default (5000) is slower but smoother

# Actual parameter values from simulated data
attributes(T.morts1)
}
