% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/journey.R
\name{journey}
\alias{journey}
\title{Plan a journey with CycleStreets.net}
\usage{
journey(
  from,
  to,
  plan = "fastest",
  silent = TRUE,
  pat = NULL,
  base_url = "https://www.cyclestreets.net",
  reporterrors = TRUE,
  save_raw = "FALSE",
  cols = c("name", "distances", "time", "busynance", "elevations", "start_longitude",
    "start_latitude", "finish_longitude", "finish_latitude"),
  cols_extra = c("crow_fly_distance", "event", "whence", "speed", "itinerary",
    "clientRouteId", "plan", "note", "length", "quietness", "west", "south", "east",
    "north", "leaving", "arriving", "grammesCO2saved", "calories", "edition",
    "gradient_segment", "elevation_change", "provisionName"),
  smooth_gradient = TRUE,
  distance_cutoff = 50,
  gradient_cutoff = 0.1,
  n = 3
)
}
\arguments{
\item{from}{Longitude/Latitude pair, e.g. \code{c(-1.55, 53.80)}}

\item{to}{Longitude/Latitude pair, e.g. \code{c(-1.55, 53.80)}}

\item{plan}{Text strong of either "fastest" (default), "quietest" or "balanced"}

\item{silent}{Logical (default is FALSE). TRUE hides request sent.}

\item{pat}{The API key used. By default this uses \code{Sys.getenv("CYCLESTREETS")}.}

\item{base_url}{The base url from which to construct API requests
(with default set to main server)}

\item{reporterrors}{Boolean value (TRUE/FALSE) indicating if cyclestreets (TRUE by default).
should report errors (FALSE by default).}

\item{save_raw}{Boolean value which returns raw list from the json if TRUE (FALSE by default).}

\item{cols}{Columns to be included in the result, a character vector or \code{NULL} for all available columns (see details for default)}

\item{cols_extra}{Additional columns to be added providing summaries of gradient and other variables}

\item{smooth_gradient}{Identify and fix anomalous gradients? TRUE by default. See
https://github.com/Robinlovelace/cyclestreets/issues/14}

\item{distance_cutoff}{Distance (m) used to identify anomalous gradients}

\item{gradient_cutoff}{Gradient (\%, e.g. 0.1 being 10\%) used to identify anomalous gradients}

\item{n}{The number of segments to use to smooth anomalous gradents.
The default is 3, meaning segments directly before, after and including the offending segment.}
}
\description{
R interface to the CycleStreets.net journey planning API,
a route planner made by cyclists for cyclists.
See \href{https://www.cyclestreets.net/api/}{cyclestreets.net/api} for details.
}
\details{
Requires the internet and a CycleStreets.net API key.
CycleStreets.net does not yet work worldwide.

You need to have an api key for this code to run.
By default it uses the CYCLESTREETS environment variable.
A quick way to set this is to install the \code{usethis} package and then
executing the following command:

\code{usethis::edit_r_environ()}

That should open up a new file in your text editor where you
can add the environment variable as follows
(replace 1a... with your key for this to work):

CYCLESTREETS=1a43ed677e5e6fe9

After setting the environment variable, as outlined above,
you need to restart your R session before the journey function will work.

A full list of variables (\code{cols}) available is represented by:\preformatted{c("time", "busynance", "signalledJunctions", "signalledCrossings",
"name", "walk", "elevations", "distances", "start", "finish",
"startSpeed", "start_longitude", "start_latitude", "finish_longitude",
"finish_latitude", "crow_fly_distance", "event", "whence", "speed",
"itinerary", "clientRouteId", "plan", "note", "length", "quietness",
"west", "south", "east", "north", "leaving", "arriving", "grammesCO2saved",
"calories", "edition", "geometry")
}

See \href{https://www.cyclestreets.net/help/journey/howitworks/}{www.cyclestreets.net/help/journey/howitworks/}
for details on how these are calculated.
}
\examples{
\dontrun{
from = c(-1.55, 53.80) # geo_code("leeds")
to = c(-1.76, 53.80) # geo_code("bradford uk")
r1 = journey(from, to)
names(r1)
r1[1:2, ]
r1$grammesCO2saved
r1$calories
plot(r1[1:4])
plot(r1[10:ncol(r1)])
to = c(-2, 53.5) # towards Manchester
r1 = journey(from, to)
names(r1)
r2 = journey(from, to, plan = "balanced")
plot(r1["quietness"], reset = FALSE)
plot(r2["quietness"], add = TRUE)
r3 = journey(from, to, silent = FALSE)
r4 = journey(from, to, save_raw = TRUE)
r5 = journey(c(-1.524, 53.819), c(-1.556, 53.806))
plot(r5["gradient_segment"])
plot(r5["gradient_smooth"])
}
}
\seealso{
json2sf_cs
}
