% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/angles.R
\name{dihedralAngles}
\alias{dihedralAngles}
\title{Dihedral angles}
\usage{
dihedralAngles(hull)
}
\arguments{
\item{hull}{an output of \code{\link{cxhull}} applied to 3D points}
}
\value{
A dataframe with three columns. The two first columns represent 
  the edges, given as a pair of vertex indices. The third column provides 
  the dihedral angle in degrees corresponding to the edge, that is the 
  angle between the two faces incident to this edge. This is useful to find 
  edges between two coplanar faces: if the faces are exactly coplanar then 
  the dihedral angle is 180, but because of numerical approximation one can 
  consider that there is coplanarity when the dihedral angle is greater 
  than 179, for example. This function is used in 
  \code{\link{plotConvexHull3d}} to get rid of such edges (if the user 
  sets a value to the argument \code{angleThreshold}).
}
\description{
Dihedral angles of a convex hull.
}
\examples{
# a cube ####
library(cxhull)
points <- rbind(
 c(0.5,0.5,0.5),
 c(0,0,0),
 c(0,0,1),
 c(0,1,0),
 c(0,1,1),
 c(1,0,0),
 c(1,0,1),
 c(1,1,0),
 c(1,1,1)
)
hull <- cxhull(points)
dihedralAngles(hull)
}
