% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv-utilities.R
\name{cvCompute}
\alias{cvCompute}
\alias{cvMixed}
\alias{cvSelect}
\alias{folds}
\alias{fold}
\alias{fold.folds}
\alias{print.folds}
\alias{GetResponse}
\alias{GetResponse.default}
\alias{GetResponse.merMod}
\alias{GetResponse.lme}
\alias{GetResponse.glmmTMB}
\alias{GetResponse.modList}
\title{Utility Functions for the cv Package}
\usage{
cvCompute(
  model,
  data = insight::get_data(model),
  criterion = mse,
  criterion.name,
  k = 10L,
  reps = 1L,
  seed,
  details = k <= 10L,
  confint,
  level = 0.95,
  method = NULL,
  ncores = 1L,
  type = "response",
  start = FALSE,
  f,
  fPara = f,
  locals = list(),
  model.function = NULL,
  model.function.name = NULL,
  ...
)

cvMixed(
  model,
  package,
  data = insight::get_data(model),
  criterion = mse,
  criterion.name,
  k,
  reps = 1L,
  confint,
  level = 0.95,
  seed,
  details,
  ncores = 1L,
  clusterVariables,
  predict.clusters.args = list(object = model, newdata = data),
  predict.cases.args = list(object = model, newdata = data),
  blups,
  fixed.effects,
  ...
)

cvSelect(
  procedure,
  data,
  criterion = mse,
  criterion.name,
  model,
  y.expression,
  k = 10L,
  confint = n >= 400,
  level = 0.95,
  reps = 1L,
  save.coef,
  details = k <= 10L,
  save.model = FALSE,
  seed,
  ncores = 1L,
  ...
)

folds(n, k)

fold(folds, i, ...)

\method{fold}{folds}(folds, i, ...)

\method{print}{folds}(x, ...)

GetResponse(model, ...)

\method{GetResponse}{default}(model, ...)

\method{GetResponse}{merMod}(model, ...)

\method{GetResponse}{lme}(model, ...)

\method{GetResponse}{glmmTMB}(model, ...)

\method{GetResponse}{modList}(model, ...)
}
\arguments{
\item{model}{a regression model object.}

\item{data}{data frame to which the model was fit (not usually necessary,
except for \code{cvSelect()}).}

\item{criterion}{cross-validation criterion ("cost" or lack-of-fit) function of form \code{f(y, yhat)}
where \code{y} is the observed values of the response and
\code{yhat} the predicted values; the default is \code{\link{mse}}
(the mean-squared error).}

\item{criterion.name}{a character string giving the name of the CV criterion function
in the returned \code{"cv"} object).}

\item{k}{perform k-fold cross-validation (default is \code{10}); \code{k}
may be a number or \code{"loo"} or \code{"n"} for n-fold (leave-one-out)
cross-validation; for \code{folds()}, \code{k} must be a number.}

\item{reps}{number of times to replicate k-fold CV (default is \code{1}).}

\item{seed}{for R's random number generator; optional, if not
supplied a random seed will be selected and saved; not needed
for n-fold cross-validation.}

\item{details}{if \code{TRUE} (the default if the number of
folds \code{k <= 10}), save detailed information about the value of the
CV criterion for the cases in each fold and the regression coefficients
with that fold deleted.}

\item{confint}{if \code{TRUE} (the default if the number of cases is 400
or greater), compute a confidence interval for the bias-corrected CV
criterion, if the criterion is the average of casewise components.}

\item{level}{confidence level (default \code{0.95}).}

\item{method}{computational method to apply; use by some \code{\link{cv}()}
methods.}

\item{ncores}{number of cores to use for parallel computations
(default is \code{1}, i.e., computations aren't done in parallel).}

\item{type}{used by some \code{\link{cv}()} methods, such as the default method,
where \code{type} is passed to the \code{type} argument of \code{predict()};
the default is \code{type="response"}, which is appropriate, e.g., for a \code{"glm"} model
and may be recognized or ignored by \code{predict()} methods for other model classes.}

\item{start}{used by some \code{\link{cv}()} methods;
if \code{TRUE} (the default is \code{FALSE}), the \code{start} argument,
set to the vector of regression coefficients for the model fit to the full data, is passed
to \code{update()}, possibly making the CV updates faster, e.g. for a GLM.}

\item{f}{function to be called by \code{cvCompute()} for each fold.}

\item{fPara}{function to be called by \code{cvCompute()} for each fold
using parallel computation.}

\item{locals}{a named list of objects that are required in the local environment
of \code{cvCompute()} for \code{f()} or \code{fPara()}.}

\item{model.function}{a regression function, typically for a new \code{cv()} method,
residing in a package that's not a declared dependency of the \pkg{cv} package,
e.g., \code{nnet::multinom}.}

\item{model.function.name}{the quoted name of the regression function, e.g.,
\code{"multinom"}.}

\item{...}{to match generic; passed to \code{predict()} for the default method,
and to \code{fPara()} (for parallel computations) in \code{cvCompute()}.}

\item{package}{the name of the package in which mixed-modeling function (or functions) employed resides;
used to get the namespace of the package.}

\item{clusterVariables}{a character vector of names of the variables
defining clusters for a mixed model with nested or crossed random effects;
if missing, cross-validation is performed for individual cases rather than
for clusters}

\item{predict.clusters.args}{a list of arguments to be used to predict
the whole data set from a mixed model when performing CV on clusters;
the first two elements should be
\code{model} and \code{newdata}; see the "Extending the cv package" vignette
(\code{vignette("cv-extend", package="cv")}).}

\item{predict.cases.args}{a list of arguments to be used to predict
the whole data set from a mixed model when performing CV on cases;
the first two elements should be
\code{model} and \code{newdata}; see the "Extending the cv package" vignette
(\code{vignette("cv-extend", package="cv")}).}

\item{blups}{a function to be used to compute BLUPs for
case-based CV when \code{details = TRUE}.}

\item{fixed.effects}{a function to be used to compute fixed-effect
coefficients for cluster-based CV when \code{details = TRUE}.}

\item{procedure}{a model-selection procedure function (see Details).}

\item{y.expression}{normally the response variable is found from the
\code{model} argument; but if, for a particular selection procedure, the
\code{model} argument is absent, or if the response can't be inferred from the
model, the response can be specified by an expression, such as \code{expression(log(income))},
to be evaluated within the data set provided by the \code{data} argument.}

\item{save.coef}{save the coefficients from the selected models? Deprecated
in favor of the \code{details} argument; if specified, \code{details} is set
is set to the value of \code{save.coef}.}

\item{save.model}{save the model that's selected using the \emph{full} data set.}

\item{n}{number of cases, for constructed folds.}

\item{folds}{an object of class \code{"folds"}.}

\item{i}{a fold number for an object of class \code{"folds"}.}

\item{x}{a \code{"cv"}, \code{"cvList"}, or \code{"folds"} object to be printed}
}
\value{
The utility functions return various kinds of objects:
\itemize{
\item \code{cvCompute()} returns an object of class \code{"cv"}, with the CV criterion
(\code{"CV crit"}), the bias-adjusted CV criterion (\code{"adj CV crit"}),
the criterion for the model applied to the full data (\code{"full crit"}),
the confidence interval and level for the bias-adjusted CV criterion (\code{"confint"}),
the number of folds (\code{"k"}), and the seed for R's random-number
generator (\code{"seed"}). If \code{details=TRUE}, then the returned object
will also include a \code{"details"} component, which is a list of two
elements: \code{"criterion"}, containing the CV criterion computed for the
cases in each fold; and \code{"coefficients"}, regression coefficients computed
for the model with each fold deleted.  Some \code{cv()} methods calling \code{cvCompute()}
may return a subset of these components and may add additional information.
If \code{reps} > \code{1}, then an object of class \code{"cvList"} is returned,
which is literally a list of \code{"cv"} objects.

\item \code{cvMixed()} also returns an object of class \code{"cv"} or
\code{"cvList"}.

\item \code{cvSelect} returns an object of class
\code{"cvSelect"} inheriting from \code{"cv"}, or an object of
class \code{"cvSelectList"} inheriting from \code{"cvList"}.

\item \code{folds()} returns an object of class folds, for which
there are \code{fold()} and \code{print()} methods.

\item \code{GetResponse()} returns the (numeric) response variable
from the model.

The supplied \code{default} method returns the \code{model$y} component
of the model object, or, if \code{model} is an S4 object, the result
returned by the \code{\link[insight]{get_response}()} function in
the \pkg{insight} package. If this result is \code{NULL}, the result of
\code{model.response(model.frame(model))} is returned, checking in any case whether
the result is a numeric vector.

There are also  \code{"lme"}, \code{"merMod"}
and \code{"glmmTMB"} methods that convert factor
responses to numeric 0/1 responses, as would be appropriate
for a generalized linear mixed model with a binary response.
}
}
\description{
These functions are primarily useful for writing methods for the
\code{\link{cv}()} generic function. They are used internally in the package
and can also be used for extensions (see the vignette "Extending the cv package,
\code{vignette("cv-extend", package="cv")}).
}
\section{Functions}{
\itemize{
\item \code{cvCompute()}: used internally by \code{cv()} methods (not for direct use);
exported to support new \code{cv()} methods.

\item \code{cvMixed()}: used internally by \code{cv()} methods
for mixed-effect models (not for direct use);
exported to support new \code{cv()} methods.

\item \code{cvSelect()}: used internally by \code{cv()} methods for
cross-validating a model-selection procedure; may also be called
directly for this purpose, but use via \code{cv()} is preferred.
\code{cvSelect()} is exported primarily to support new model-selection procedures.

\item \code{folds()}: used internally by \code{cv()} methods (not for direct use).

\item \code{fold()}: to extract a fold from a \code{"folds"} object.

\item \code{fold(folds)}: \code{fold()} method for \code{"folds"} objects.

\item \code{print(folds)}: \code{print()} method for \code{"folds"} objects.

\item \code{GetResponse()}: function to return the response variable
from a regression model.

\item \code{GetResponse(default)}: default method.

\item \code{GetResponse(merMod)}: \code{"merMod"} method.

\item \code{GetResponse(lme)}: \code{"lme"} method.

\item \code{GetResponse(glmmTMB)}: \code{"glmmTMB"} method.

\item \code{GetResponse(modList)}: \code{"modList"} method.

}}
\examples{
fit <- lm(mpg ~ gear, mtcars)
GetResponse(fit)

set.seed(123)
(ffs <- folds(n=22, k=5))
fold(ffs, 2)

}
\seealso{
\code{\link{cv}}, \code{\link{cv.merMod}},
\code{\link{cv.function}}.
}
