% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{metric_constrain}
\alias{metric_constrain}
\alias{sens_constrain}
\alias{spec_constrain}
\alias{acc_constrain}
\title{Metrics that are constrained by another metric}
\usage{
metric_constrain(tp, fp, tn, fn, main_metric = sensitivity,
  constrain_metric = specificity, min_constrain = 0.5,
  suffix = "_constrain", ...)

sens_constrain(tp, fp, tn, fn, constrain_metric = specificity,
  min_constrain = 0.5, ...)

spec_constrain(tp, fp, tn, fn, constrain_metric = sensitivity,
  min_constrain = 0.5, ...)

acc_constrain(tp, fp, tn, fn, constrain_metric = sensitivity,
  min_constrain = 0.5, ...)
}
\arguments{
\item{tp}{(numeric) number of true positives.}

\item{fp}{(numeric) number of false positives.}

\item{tn}{(numeric) number of true negatives.}

\item{fn}{(numeric) number of false negatives.}

\item{main_metric}{Metric to be optimized.}

\item{constrain_metric}{Metric for constraint.}

\item{min_constrain}{Minimum desired value of constrain_metric.}

\item{suffix}{Character string to be added to the name of main_metric.}

\item{...}{for capturing additional arguments passed by method.}
}
\description{
For example, calculate sensitivity where
a lower bound (minimal desired value) for specificty can be defined. All returned
metric values for cutpoints that lead to values of the constraining metric
below the specified minimum will be zero.
The inputs must be vectors of equal length.
}
\examples{
## Maximum sensitivity when specificity is at least 95\%
cp <- cutpointr(suicide, dsi, suicide,
  metric = sens_constrain, constrain_metric = ppv, min_constrain = 0.75)
plot_metric(cp)
}
\seealso{
Other metric functions: \code{\link{F1_score}},
  \code{\link{abs_d_ppv_npv}},
  \code{\link{abs_d_sens_spec}}, \code{\link{accuracy}},
  \code{\link{cohens_kappa}}, \code{\link{cutpoint}},
  \code{\link{false_omission_rate}},
  \code{\link{misclassification_cost}}, \code{\link{npv}},
  \code{\link{odds_ratio}}, \code{\link{p_chisquared}},
  \code{\link{plr}}, \code{\link{ppv}},
  \code{\link{precision}}, \code{\link{prod_ppv_npv}},
  \code{\link{prod_sens_spec}}, \code{\link{recall}},
  \code{\link{risk_ratio}}, \code{\link{roc01}},
  \code{\link{sensitivity}}, \code{\link{specificity}},
  \code{\link{sum_ppv_npv}}, \code{\link{sum_sens_spec}},
  \code{\link{total_utility}}, \code{\link{tpr}},
  \code{\link{tp}}, \code{\link{youden}}
}
\concept{metric functions}
