% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_sensitivity_specificity.R
\name{plot_sensitivity_specificity}
\alias{plot_sensitivity_specificity}
\title{Sensitivity and specificity plot from a cutpointr object}
\usage{
plot_sensitivity_specificity(x, display_cutpoint = TRUE, ...)
}
\arguments{
\item{x}{A cutpointr object.}

\item{display_cutpoint}{(logical) Whether or not to display the optimal
cutpoint as a dot on the precision recall curve.}

\item{...}{Additional arguments (unused).}
}
\description{
Given a \code{cutpointr} object this function plots the sensitivity and specificity
curve(s) per subgroup, if the latter is given.
}
\examples{
library(cutpointr)

## Optimal cutpoint for dsi
data(suicide)
opt_cut <- cutpointr(suicide, dsi, suicide)
plot_sensitivity_specificity(opt_cut)
}
\seealso{
Other cutpointr plotting functions: \code{\link{plot.cutpointr}},
  \code{\link{plot_cut_boot}},
  \code{\link{plot_cutpointr}},
  \code{\link{plot_metric_boot}},
  \code{\link{plot_metric}},
  \code{\link{plot_precision_recall}},
  \code{\link{plot_roc}}, \code{\link{plot_x}}
}
