% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cusum_limit_sim.R
\name{cusum_limit_sim}
\alias{cusum_limit_sim}
\title{Simulate control limit given false signal probability alpha for CUSUM charts}
\usage{
cusum_limit_sim(failure_probability, n_patients, odds_multiplier,
  n_simulation, alpha, seed = NULL)
}
\arguments{
\item{failure_probability}{Double. Baseline failure probability}

\item{n_patients}{Integer. Number of patients in monitoring period /sample size}

\item{odds_multiplier}{Double. Odds multiplier of adverse event under the alternative hypothesis (<1 looks for decreases)}

\item{n_simulation}{Integer. Number of simulation runs}

\item{alpha}{Double. False signal probability of CUSUM}

\item{seed}{Integer. Seed for RNG}
}
\value{
Returns the control limit for signalling performance change (double)
}
\description{
Simulate control limit given false signal probability alpha for CUSUM charts
}
\examples{

# simulate control limits for alpha = 0.05
cusum_limit_sim(
  failure_probability = 0.05,
  n_patients = 100,
  odds_multiplier = 2,
  n_simulation = 1000,
  alpha = 0.05,
  seed = 2046
)
}
