% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step.R
\name{step}
\alias{step}
\alias{given}
\alias{when}
\alias{then}
\title{Define a step}
\usage{
given(description, implementation)

when(description, implementation)

then(description, implementation)
}
\arguments{
\item{description}{A description of the step.

A simple version of a \href{https://github.com/cucumber/cucumber-expressions}{Cucumber expression}.
The description is used by the \code{cucumber::test} function to find an implementation of a step
from a feature file.
The description can contain placeholders in curly braces, e.g. \code{"I have {int} cucumbers in my basket"}.
If no step definition is found an error will be thrown. If multiple steps definitions for a single step
are found an error will be thrown. Make sure the description is unique for each step.}

\item{implementation}{A function that will be run when the step is executed.
The implementation function should always have the last parameter named \code{context}.
It holds the environment where state should be stored to be passed to the next step.

If a step has a description \code{"I have {int} cucumbers in my basket"} then the implementation
function should be a \code{function(n_cucumbers, context)}. The \code{{int}} value will be passed to
\code{n_cucumbers}, this parameter can have any name.

If a table or a docstring is defined for a step, it will be passed as an argument after plceholder parameters
and before \code{context}. The function should be a \code{function(n_cucumbers, table, context)}.
See
\href{https://github.com/jakubsob/cucumber/blob/main/inst/examples/table/tests/testthat/steps/steps.R}{an example}
on how to write implementation that uses tables or docstrings.}
}
\value{
A function of class \code{step}, invisibly. Function should be called for side effects.
}
\description{
Provide a description that matches steps in feature files and the implementation function that will be run.
}
\details{
Placeholders in expressions are replaced with regular expressions that match values in the feature file.
The regular expressions are generated during runtime based on defined parameter types.
The expression \code{"I have {int} cucumbers in my basket"} will be converted to
\code{"I have [+-]?(?<![.])[:digit:]+(?![.]) cucumbers in my basket"}. The extracted value of \code{{int}}
will be passed to the implementation function after being transformed with \code{as.integer}.

To define your own parameter types use \code{\link{define_parameter_type}}.
}
\examples{
given("I have {int} cucumbers in my basket", function(n_cucumbers, context) {
  context$n_cucumbers <- n_cucumbers
})

given("I have {int} cucumbers in my basket and a table", function(n_cucumbers, table, context) {
  context$n_cucumbers <- n_cucumbers
  context$table <- table
})

when("I eat {int} cucumbers", function(n_cucumbers, context) {
  context$n_cucumbers <- context$n_cucumbers - n_cucumbers
})

then("I should have {int} cucumbers in my basket", function(n_cucumbers, context) {
  expect_equal(context$n_cucumbers, n_cucumbers)
})

}
\seealso{
\code{\link[=define_parameter_type]{define_parameter_type()}}
}
