% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codon_weight.R
\name{est_optimal_codons}
\alias{est_optimal_codons}
\title{Estimate optimal codons}
\usage{
est_optimal_codons(seqs, codon_table = get_codon_table())
}
\arguments{
\item{seqs}{CDS sequences of all protein-coding genes. One for each gene.}

\item{codon_table}{a table of genetic code derived from `get_codon_table` or `create_codon_table`.}
}
\value{
data.table of optimal codons
}
\description{
\code{est_toptimal_codons} determine optimal codon of each codon family with binomial regression.
  Usage of optimal codons should correlate negatively with enc.
}
\examples{
# perform binomial regression for optimal codon estimation
codons_opt <- est_optimal_codons(yeast_cds)
# select optimal codons with a fdr of 0.001
codons_opt <- codons_opt[qvalue < 0.001 & coef < 0]
codons_opt

}
