% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.kmeans.ct.R
\name{plot.kmeans.ct}
\alias{plot.kmeans.ct}
\title{Plot a kmeans.ct object}
\usage{
\method{plot}{kmeans.ct}(
  x,
  type = "functions",
  mark.transitions = TRUE,
  col = NULL,
  lty = NULL,
  xlab = "Time",
  ylab = NULL,
  legend = TRUE,
  ncol.legend = 1,
  cex.legend = 1,
  ...
)
}
\arguments{
\item{x}{clustering object produced by \code{\link{kmeans.ct}}}

\item{type}{either \code{"functions"} (the default), to display each variable
as a smooth function of time, or \code{"distance"}, to plot distances from the
k cluster means versus time.}

\item{mark.transitions}{logical: Should transitions between clusters be marked
with vertical lines? Defaults to \code{TRUE}.}

\item{col}{plot colors}

\item{lty}{line type}

\item{xlab, ylab}{x- and y-axis labels}

\item{legend}{either a logical variable (whether a legend should be included) or a character
vector to appear in the legend. Default is \code{TRUE}.}

\item{ncol.legend}{number of columns for legend}

\item{cex.legend}{character expansion factor for legend}

\item{\dots}{other arguments passed to \code{\link{matplot}}}
}
\value{
None; a plot is generated.
}
\description{
Plots a continuous-time k-means clustering object generated by a call
to \code{\link{kmeans.ct}}.
}
\seealso{
\code{\link{kmeans.ct}}, which includes an example
}
\author{
Biplab Paul <paul.biplab497@gmail.com> and Philip Tzvi Reiss <reiss@stat.haifa.ac.il>
}
