#' Continuous-Time Multivariate Analysis
#'
#' Implements continuous-time analogues of several classical techniques of multivariate analysis.
#' The inputs are \code{"\link[fda]{fd}"} (functional data) objects from the \pkg{fda} package.
#'
#' @name ctmva-package
#' @aliases ctmva-package ctmva
#' @docType package
#'
#' @author Biplab Paul <paul.biplab497@gmail.com> and Philip Tzvi Reiss <reiss@stat.haifa.ac.il>
#'
#' @references Paul, Biplab; Reiss, Philip T.;  and Cui, Erjia (2023).
#' Continuous-time multivariate analysis. Preprint, doi.org/10.48550/arXiv.2307.09404.
#'
#' @keywords package
#'
#' @importFrom fda fd eval.basis eval.fd
#' @importFrom graphics abline legend matplot mtext
#' @importFrom stats as.formula lm runif

NULL



