% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_mutations_read_counts.R
\name{get_mutations_read_counts}
\alias{get_mutations_read_counts}
\title{Counts ref and alt reads for a set of mutations}
\usage{
get_mutations_read_counts(mutations, bam, tag = "",
  min_base_quality = 20, max_depth = 1e+05, min_mapq = 30)
}
\arguments{
\item{mutations}{A data frame with the reporter mutations. Should have the columns CHROM, POS, REF, ALT.}

\item{bam}{path to bam file}

\item{tag}{the RG tag if the bam has more than one sample}

\item{min_base_quality}{minimum base quality for a read to be counted}

\item{max_depth}{maximum depth above which sampling will happen}

\item{min_mapq}{the minimum mapping quality for a read to be counted}
}
\value{
a named list contains: ref, vector of read counts of the reference alleles, and
        alt, vector of read counts of the alternative allele
}
\description{
Counts ref and alt reads for a set of mutations in a bam file
}
\details{
Quantifies the reference and variant alleles for the input mutations in the input bam file. Useful for forced calling mutations.
}
\examples{
data("mutations", package = "ctDNAtools")
bamT1 <- system.file("extdata", "T1.bam", package = "ctDNAtools")
get_mutations_read_counts(mutations = mutations[1:3, ], bam = bamT1)
}
\seealso{
\code{\link{get_mutations_read_names}} \code{\link{test_ctDNA}} \code{\link{get_mutations_fragment_size}}
}
