% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop.R
\name{drop_csquares}
\alias{drop_csquares}
\title{Drop c-square information from object}
\usage{
drop_csquares(x, ...)
}
\arguments{
\item{x}{An object of class \code{csquares} from which the c-square information
needs to be dropped.}

\item{...}{ignored}
}
\value{
Returns a copy of \code{x} inheriting its parent classes but with out
csquares info.
}
\description{
Drops c-square data from an object, but keeps the parent class of the object
intact. You cannot deselect the csquare column from a \code{csquares} object as this
will render the object invalid. Use \code{drop_csquares} instead.
}
\examples{
csq <- as_csquares("1000")
drop_csquares(csq)

csq <-
  data.frame(csquares = "1000", foo = "bar") |>
  as_csquares(csquares = "csquares")

drop_csquares(csq)
}
\author{
Pepijn de Vries
}
