% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise.R
\name{summarise}
\alias{summarise}
\alias{summarise.csquares}
\title{Summarise c-square data to a lower resolution}
\usage{
summarise.csquares(x, ..., .by, tiers_down = 1L)
}
\arguments{
\item{x}{The object to be summarised. Can be a \code{data.frame}, \code{\link[sf:sf]{sf}}, or
\code{\link[stars:st_as_stars]{stars}} object.}

\item{...}{<\code{\link[rlang:args_data_masking]{data-masking}}> Name-value pairs of
summary functions. The name will be the name of the variable in the result.

The value can be:
\itemize{
\item A vector of length 1, e.g. \code{min(x)}, \code{n()}, or \code{sum(is.na(y))}.
\item A data frame, to add multiple columns from a single expression.
}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Returning values with size 0 or >1 was
deprecated as of 1.1.0. Please use \code{\link[dplyr:reframe]{reframe()}} for this instead.}

\item{.by}{The column name that holds the c-squares codes that need to be aggregated.}

\item{tiers_down}{The number of tiers down from the current resolution to which you wish to
summarise. If the current resolution is 5x5 degrees, the tier down would be 10x10 degrees
(as is the case in the example below).}
}
\value{
Returns the summarised object inheriting its class from \code{x}
}
\description{
This function acts very much like \link[dplyr:summarise]{dplyr::summarise}, but instead of using a column to group,
c-square codes are used to aggregate to a lower resolution and summarise the data to that lower
resolution.
}
\examples{
library(dplyr)
orca |>
  as_csquares(csquares = "csquares") |>
  summarise(
    .by = "csquares",
    orcinus_orca = any(na.omit(.data$orcinus_orca)))

}
\author{
Pepijn de Vries
}
