/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.tools;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class AttributeMapping {
    private List aAttributeNames;
    private List bAttributeNames;
    private List aNewAttributeNames;
    private List bNewAttributeNames;
    private FeatureSchema aSchema;
    private FeatureSchema bSchema;

    protected AttributeMapping() {
    }

    public AttributeMapping(FeatureSchema a, FeatureSchema b) {
        this.init(a, this.nonSpatialAttributeNames(a, null, null), this.nonSpatialAttributeNames(a, b, "_1"), b, this.nonSpatialAttributeNames(b, null, null), this.nonSpatialAttributeNames(b, a, "_2"));
    }

    public AttributeMapping(FeatureSchema aSchema, List aAttributeNames, List aNewAttributeNames, FeatureSchema bSchema, List bAttributeNames, List bNewAttributeNames) {
        this.init(aSchema, aAttributeNames, aNewAttributeNames, bSchema, bAttributeNames, bNewAttributeNames);
    }

    private List nonSpatialAttributeNames(FeatureSchema schema, FeatureSchema other, String postfix) {
        ArrayList<String> attributeNames = new ArrayList<String>();
        for (int i = 0; i < schema.getAttributeCount(); ++i) {
            if (schema.getAttributeType(i) == AttributeType.GEOMETRY) continue;
            String attributeName = schema.getAttributeName(i);
            if (other != null && other.hasAttribute(attributeName)) {
                attributeName = attributeName + postfix;
            }
            attributeNames.add(attributeName);
        }
        return attributeNames;
    }

    private void init(FeatureSchema aSchema, List aAttributeNames, List aNewAttributeNames, FeatureSchema bSchema, List bAttributeNames, List bNewAttributeNames) {
        Assert.isTrue((boolean)this.isDisjoint(aNewAttributeNames, bNewAttributeNames));
        Assert.isTrue((aAttributeNames.size() == aNewAttributeNames.size() ? 1 : 0) != 0);
        Assert.isTrue((bAttributeNames.size() == bNewAttributeNames.size() ? 1 : 0) != 0);
        this.aSchema = aSchema;
        this.bSchema = bSchema;
        this.aAttributeNames = new ArrayList(aAttributeNames);
        this.bAttributeNames = new ArrayList(bAttributeNames);
        this.aNewAttributeNames = new ArrayList(aNewAttributeNames);
        this.bNewAttributeNames = new ArrayList(bNewAttributeNames);
    }

    public CombinedSchema createSchema(String geometryName) {
        CombinedSchema newSchema = new CombinedSchema();
        this.addAttributes(newSchema, this.aSchema, this.aAttributeNames, this.aNewAttributeNames, newSchema.aNewToOldAttributeIndexMap);
        newSchema.lastNewAttributeIndexForA = newSchema.getAttributeCount() - 1;
        this.addAttributes(newSchema, this.bSchema, this.bAttributeNames, this.bNewAttributeNames, newSchema.bNewToOldAttributeIndexMap);
        newSchema.addAttribute(geometryName, AttributeType.GEOMETRY);
        return newSchema;
    }

    private void addAttributes(FeatureSchema newSchema, FeatureSchema sourceSchema, List attributeNames, List newAttributeNames, Map newToOldAttributeIndexMap) {
        for (int i = 0; i < attributeNames.size(); ++i) {
            String attributeName = (String)attributeNames.get(i);
            String newAttributeName = (String)newAttributeNames.get(i);
            AttributeType type = sourceSchema.getAttributeType(attributeName);
            if (type == AttributeType.GEOMETRY) continue;
            newSchema.addAttribute(newAttributeName, type);
            newToOldAttributeIndexMap.put(new Integer(newSchema.getAttributeCount() - 1), new Integer(i));
        }
    }

    protected boolean isDisjoint(Collection a, Collection b) {
        HashSet c = new HashSet();
        c.addAll(a);
        c.addAll(b);
        return c.size() == a.size() + b.size();
    }

    public void transferAttributes(Feature aFeature, Feature bFeature, Feature cFeature) {
        this.transferAttributes(aFeature, cFeature, this.aAttributeNames, this.aNewAttributeNames);
        this.transferAttributes(bFeature, cFeature, this.bAttributeNames, this.bNewAttributeNames);
    }

    private void transferAttributes(Feature source, Feature dest, List attributeNames, List newAttributeNames) {
        for (int i = 0; i < attributeNames.size(); ++i) {
            String attributeName = (String)attributeNames.get(i);
            String newAttributeName = (String)newAttributeNames.get(i);
            Assert.isTrue((source.getSchema().getAttributeType(attributeName) != AttributeType.GEOMETRY ? 1 : 0) != 0);
            dest.setAttribute(newAttributeName, source.getAttribute(attributeName));
        }
    }

    public static class CombinedSchema
    extends FeatureSchema {
        private static final long serialVersionUID = -8627306219650589202L;
        private Map aNewToOldAttributeIndexMap = new HashMap();
        private Map bNewToOldAttributeIndexMap = new HashMap();
        private int lastNewAttributeIndexForA;

        public int toAOldAttributeIndex(int newAttributeIndex) {
            return (Integer)this.aNewToOldAttributeIndexMap.get(new Integer(newAttributeIndex));
        }

        public int toBOldAttributeIndex(int newAttributeIndex) {
            return (Integer)this.bNewToOldAttributeIndexMap.get(new Integer(newAttributeIndex));
        }

        public boolean isFromA(int newAttributeIndex) {
            return newAttributeIndex <= this.lastNewAttributeIndexForA;
        }
    }
}

