/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.plugin.qa;

import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.qa.diff.DiffSegments;
import com.vividsolutions.jump.qa.diff.DiffSegmentsWithTolerance;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerStyleUtil;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedBasePlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class DiffSegmentsPlugIn
extends ThreadedBasePlugIn {
    private static final String LAYER1 = "Layer 1";
    private static final String LAYER2 = "Layer 2";
    private static final String USE_TOLERANCE = "Use Distance Tolerance";
    private static final String DISTANCE_TOL = "Distance Tolerance";
    private Layer layer1;
    private Layer layer2;
    private boolean useTolerance = false;
    private double distanceTolerance = 0.0;

    public boolean execute(PlugInContext context) throws Exception {
        MultiInputDialog dialog = new MultiInputDialog((Frame)context.getWorkbenchFrame(), "Diff Segments", true);
        this.setDialogValues(dialog, context);
        GUIUtil.centreOnWindow((Component)dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        return true;
    }

    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        FeatureCollection[] diffFC;
        if (!this.useTolerance) {
            DiffSegments diff = new DiffSegments(monitor);
            diff.setSegments(0, this.layer1.getFeatureCollectionWrapper());
            diff.setSegments(1, this.layer2.getFeatureCollectionWrapper());
            diffFC = new FeatureCollection[]{diff.computeDiffEdges(0), diff.computeDiffEdges(1)};
        } else {
            DiffSegmentsWithTolerance diff = new DiffSegmentsWithTolerance(this.layer1.getFeatureCollectionWrapper(), this.layer2.getFeatureCollectionWrapper(), this.distanceTolerance);
            diffFC = diff.diff();
        }
        this.createLayers(context, diffFC);
        this.createOutput(context, diffFC);
    }

    private void createLayers(PlugInContext context, FeatureCollection[] diffFC) {
        Layer lyr = context.addLayer("QA", "Segment Diffs - " + this.layer1.getName(), diffFC[0]);
        LayerStyleUtil.setLinearStyle((Layer)lyr, (Color)Color.red, (int)2, (int)4);
        lyr.fireAppearanceChanged();
        Layer lyr2 = context.addLayer("QA", "Segment Diffs - " + this.layer2.getName(), diffFC[1]);
        LayerStyleUtil.setLinearStyle((Layer)lyr2, (Color)Color.blue, (int)2, (int)4);
        lyr2.fireAppearanceChanged();
    }

    private void createOutput(PlugInContext context, FeatureCollection[] diffFC) {
        context.getOutputFrame().createNewDocument();
        context.getOutputFrame().addHeader(1, "Diff Segments");
        context.getOutputFrame().addField("Layer 1: ", this.layer1.getName());
        context.getOutputFrame().addField("Layer 2: ", this.layer2.getName());
        context.getOutputFrame().addText(" ");
        if (this.useTolerance) {
            context.getOutputFrame().addField("Distance Tolerance: ", "" + this.distanceTolerance);
        }
        context.getOutputFrame().addField("# Unmatched Segments in Layer 1: ", "" + diffFC[0].size());
        context.getOutputFrame().addField("# Unmatched Segments in Layer 2: ", "" + diffFC[1].size());
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarImage((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("DiffSegments.png")));
        dialog.setSideBarDescription("Finds line segments which occur in Layer 1 or Layer 2 but not both.");
        dialog.addLayerComboBox(LAYER1, context.getLayerManager().getLayer(0), context.getLayerManager());
        dialog.addLayerComboBox(LAYER2, context.getLayerManager().getLayer(1), context.getLayerManager());
        dialog.addCheckBox(USE_TOLERANCE, this.useTolerance, "Match segments if all points are within a Distance Tolerance");
        dialog.addDoubleField(DISTANCE_TOL, this.distanceTolerance, 8, "The Distance Tolerance specifies how close segments must be to match");
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.layer1 = dialog.getLayer(LAYER1);
        this.layer2 = dialog.getLayer(LAYER2);
        this.useTolerance = dialog.getBoolean(USE_TOLERANCE);
        this.distanceTolerance = dialog.getDouble(DISTANCE_TOL);
    }
}

