/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.datastore.postgis;

import com.vividsolutions.jump.datastore.jdbc.ValueConverter;
import com.vividsolutions.jump.datastore.postgis.PostgisValueConverterFactory;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class PostgisResultSetConverter {
    private ResultSet rs;
    private FeatureSchema featureSchema;
    private int geometryColIndex = -1;
    private ValueConverter[] mapper;
    private PostgisValueConverterFactory odm;
    private boolean isInitialized = false;

    public PostgisResultSetConverter(Connection conn, ResultSet rs) {
        this.odm = new PostgisValueConverterFactory(conn);
        this.rs = rs;
    }

    public FeatureSchema getFeatureSchema() throws SQLException {
        this.init();
        return this.featureSchema;
    }

    public Feature getFeature() throws Exception {
        this.init();
        BasicFeature f = new BasicFeature(this.featureSchema);
        for (int i = 0; i < this.mapper.length; ++i) {
            f.setAttribute(i, this.mapper[i].getValue(this.rs, i + 1));
        }
        return f;
    }

    private void init() throws SQLException {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        ResultSetMetaData rsmd = this.rs.getMetaData();
        int numberOfColumns = rsmd.getColumnCount();
        this.mapper = new ValueConverter[numberOfColumns];
        this.featureSchema = new FeatureSchema();
        for (int i = 0; i < numberOfColumns; ++i) {
            this.mapper[i] = this.odm.getConverter(rsmd, i + 1);
            String colName = rsmd.getColumnName(i + 1);
            if (this.mapper[i].getType() == AttributeType.GEOMETRY) {
                colName = "GEOMETRY";
            }
            this.featureSchema.addAttribute(colName, this.mapper[i].getType());
        }
    }
}

