/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.parameter;

import com.vividsolutions.jump.parameter.ParameterListSchema;
import com.vividsolutions.jump.util.LangUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ParameterList {
    private ParameterListSchema schema;
    private Map params = new HashMap();

    public ParameterList(ParameterListSchema schema) {
        this.initialize(schema);
    }

    public ParameterList(ParameterList other) {
        this.initialize(other.getSchema());
        Iterator<String> i = Arrays.asList(other.getSchema().getNames()).iterator();
        while (i.hasNext()) {
            String name = i.next();
            this.setParameter(name, other.getParameter(name));
        }
    }

    protected ParameterList initialize(ParameterListSchema schema) {
        this.schema = schema;
        return this;
    }

    public ParameterListSchema getSchema() {
        return this.schema;
    }

    public ParameterList setParameter(String name, Object value) {
        this.params.put(name, value);
        return this;
    }

    public boolean equals(Object obj) {
        return this.equals((ParameterList)obj);
    }

    private boolean equals(ParameterList other) {
        if (!this.schema.equals((Object)other.schema)) {
            return false;
        }
        Iterator i = this.params.keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            if (LangUtil.bothNullOrEqual(this.params.get(name), other.params.get(name))) continue;
            return false;
        }
        return true;
    }

    public Object getParameter(String name) {
        return this.params.get(name);
    }

    public String getParameterString(String name) {
        return (String)this.params.get(name);
    }

    public int getParameterInt(String name) {
        Object value = this.params.get(name);
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        return (Integer)this.params.get(name);
    }
}

