/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.util;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;

public class GeometricShapeFactory {
    private GeometryFactory geomFact;
    private Dimensions dim = new Dimensions();
    private int nPts = 100;

    public GeometricShapeFactory() {
        this(new GeometryFactory());
    }

    public GeometricShapeFactory(GeometryFactory geomFact) {
        this.geomFact = geomFact;
    }

    public void setBase(Coordinate base) {
        this.dim.setBase(base);
    }

    public void setCentre(Coordinate centre) {
        this.dim.setCentre(centre);
    }

    public void setNumPoints(int nPts) {
        this.nPts = nPts;
    }

    public void setSize(double size) {
        this.dim.setSize(size);
    }

    public void setWidth(double width) {
        this.dim.setWidth(width);
    }

    public void setHeight(double height) {
        this.dim.setHeight(height);
    }

    public Polygon createRectangle() {
        double y;
        double x;
        int i;
        int ipt = 0;
        int nSide = this.nPts / 4;
        if (nSide < 1) {
            nSide = 1;
        }
        double XsegLen = this.dim.getEnvelope().getWidth() / (double)nSide;
        double YsegLen = this.dim.getEnvelope().getHeight() / (double)nSide;
        Coordinate[] pts = new Coordinate[4 * nSide + 1];
        Envelope env = this.dim.getEnvelope();
        double maxx = env.getMinX() + (double)nSide * XsegLen;
        double maxy = env.getMinY() + (double)nSide * XsegLen;
        for (i = 0; i < nSide; ++i) {
            x = env.getMinX() + (double)i * XsegLen;
            y = env.getMinY();
            pts[ipt++] = new Coordinate(x, y);
        }
        for (i = 0; i < nSide; ++i) {
            x = env.getMaxX();
            y = env.getMinY() + (double)i * YsegLen;
            pts[ipt++] = new Coordinate(x, y);
        }
        for (i = 0; i < nSide; ++i) {
            x = env.getMaxX() - (double)i * XsegLen;
            y = env.getMaxY();
            pts[ipt++] = new Coordinate(x, y);
        }
        for (i = 0; i < nSide; ++i) {
            x = env.getMinX();
            y = env.getMaxY() - (double)i * YsegLen;
            pts[ipt++] = new Coordinate(x, y);
        }
        pts[ipt++] = new Coordinate(pts[0]);
        LinearRing ring = this.geomFact.createLinearRing(pts);
        Polygon poly = this.geomFact.createPolygon(ring, null);
        return poly;
    }

    public Polygon createCircle() {
        Envelope env = this.dim.getEnvelope();
        double xRadius = env.getWidth() / 2.0;
        double yRadius = env.getHeight() / 2.0;
        double centreX = env.getMinX() + xRadius;
        double centreY = env.getMinY() + yRadius;
        Coordinate[] pts = new Coordinate[this.nPts + 1];
        int iPt = 0;
        for (int i = 0; i < this.nPts; ++i) {
            double ang = (double)i * (Math.PI * 2 / (double)this.nPts);
            double x = xRadius * Math.cos(ang) + centreX;
            double y = yRadius * Math.sin(ang) + centreY;
            Coordinate pt = new Coordinate(x, y);
            pts[iPt++] = pt;
        }
        pts[iPt] = pts[0];
        LinearRing ring = this.geomFact.createLinearRing(pts);
        Polygon poly = this.geomFact.createPolygon(ring, null);
        return poly;
    }

    public LineString createArc(double startAng, double endAng) {
        Envelope env = this.dim.getEnvelope();
        double xRadius = env.getWidth() / 2.0;
        double yRadius = env.getHeight() / 2.0;
        double centreX = env.getMinX() + xRadius;
        double centreY = env.getMinY() + yRadius;
        double angSize = endAng - startAng;
        if (angSize <= 0.0 || angSize > Math.PI * 2) {
            angSize = Math.PI * 2;
        }
        double angInc = angSize / (double)this.nPts;
        Coordinate[] pts = new Coordinate[this.nPts];
        int iPt = 0;
        for (int i = 0; i < this.nPts; ++i) {
            double ang = startAng + (double)i * angInc;
            double x = xRadius * Math.cos(ang) + centreX;
            double y = yRadius * Math.sin(ang) + centreY;
            Coordinate pt = new Coordinate(x, y);
            this.geomFact.getPrecisionModel().makePrecise(pt);
            pts[iPt++] = pt;
        }
        LineString line = this.geomFact.createLineString(pts);
        return line;
    }

    private class Dimensions {
        public Coordinate base;
        public Coordinate centre;
        public double width;
        public double height;

        private Dimensions() {
        }

        public void setBase(Coordinate base) {
            this.base = base;
        }

        public void setCentre(Coordinate centre) {
            this.centre = centre;
        }

        public void setSize(double size) {
            this.height = size;
            this.width = size;
        }

        public void setWidth(double width) {
            this.width = width;
        }

        public void setHeight(double height) {
            this.height = height;
        }

        public Envelope getEnvelope() {
            if (this.base != null) {
                return new Envelope(this.base.x, this.base.x + this.width, this.base.y, this.base.y + this.height);
            }
            if (this.centre != null) {
                return new Envelope(this.centre.x - this.width / 2.0, this.centre.x + this.width / 2.0, this.centre.y - this.height / 2.0, this.centre.y + this.height / 2.0);
            }
            return new Envelope(0.0, this.width, 0.0, this.height);
        }
    }
}

