/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.qa.diff;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.index.SpatialIndex;
import com.vividsolutions.jts.index.quadtree.Quadtree;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.util.CoordinateArrays;
import java.util.Iterator;
import java.util.List;

public class SegmentIndex {
    private SpatialIndex segIndex = new Quadtree();
    private Envelope itemEnv = new Envelope();

    public SegmentIndex(FeatureCollection fc) {
        Iterator i = fc.iterator();
        while (i.hasNext()) {
            Feature f = (Feature)i.next();
            this.add(f.getGeometry());
        }
    }

    public void add(Geometry geom) {
        this.add(CoordinateArrays.toCoordinateArrays(geom, false));
    }

    public void add(LineString line) {
        this.add(line.getCoordinates());
    }

    public void add(List coordArrays) {
        Iterator i = coordArrays.iterator();
        while (i.hasNext()) {
            this.add((Coordinate[])i.next());
        }
    }

    public void add(Coordinate[] coord) {
        for (int i = 0; i < coord.length - 1; ++i) {
            LineSegment lineseg = new LineSegment(coord[i], coord[i + 1]);
            lineseg.normalize();
            this.itemEnv.init(lineseg.p0, lineseg.p1);
            this.segIndex.insert(this.itemEnv, (Object)lineseg);
        }
    }

    public List query(Envelope env) {
        return this.segIndex.query(env);
    }
}

