% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crypto_history.R
\name{crypto_history}
\alias{crypto_history}
\title{Get historic crypto currency market data}
\usage{
crypto_history(
  coin_list = NULL,
  convert = "USD",
  limit = NULL,
  start_date = NULL,
  end_date = NULL,
  interval = NULL,
  requestLimit = 400,
  sleep = 0,
  wait = 60,
  finalWait = FALSE,
  single_id = TRUE
)
}
\arguments{
\item{coin_list}{string if NULL retrieve all currently existing coins (\code{crypto_list()}),
or provide list of crypto currencies in the \code{crypto_list()} or \code{cryptoi_listings()} format (e.g. current and/or dead coins since 2015)}

\item{convert}{(default: USD) to one of available fiat prices (\code{fiat_list()}) or bitcoin 'BTC'. Be aware, that since 2024 only USD and BTC are available here!}

\item{limit}{integer Return the top n records, default is all tokens}

\item{start_date}{date Start date to retrieve data from}

\item{end_date}{date End date to retrieve data from, if not provided, today will be assumed}

\item{interval}{string Interval with which to sample data according to what \code{seq()} needs}

\item{requestLimit}{limiting the length of request URLs when bundling the api calls}

\item{sleep}{integer (default 60) Seconds to sleep between API requests}

\item{wait}{waiting time before retry in case of fail (needs to be larger than 60s in case the server blocks too many attempts, default=60)}

\item{finalWait}{to avoid calling the web-api again with another command before 60s are over (TRUE=default)}

\item{single_id}{Download data coin by coin (as of May 2024 this is necessary)}
}
\value{
Crypto currency historic OHLC market data in a dataframe and additional information via attribute "info":
\item{timestamp}{Timestamp of entry in database}
\item{id}{Coin market cap unique id}
\item{name}{Coin name}
\item{symbol}{Coin symbol}
\item{ref_cur_id}{reference Currency id}
\item{ref_cur_name}{reference Currency name}
\item{open}{Market open}
\item{high}{Market high}
\item{low}{Market low}
\item{close}{Market close}
\item{volume}{Volume 24 hours}
\item{market_cap}{Market cap - close x circulating supply}
\item{time_open}{Timestamp of open}
\item{time_close}{Timestamp of close}
\item{time_high}{Timestamp of high}
\item{time_low}{Timestamp of low}

This is the main function of the crypto package. If you want to retrieve
ALL active coins then do not pass an argument to \code{crypto_history()}, alternatively pass the coin name.
}
\description{
Scrape the crypto currency historic market tables from
'CoinMarketCap' \url{https://coinmarketcap.com} and display
the results in a dataframe/tibble. This can be used to conduct
analysis on the crypto financial markets or to attempt
to predict future market movements or trends.
}
\examples{
\dontrun{

# Retrieving market history for ALL crypto currencies
all_coins <- crypto_history(limit = 2)
one_coin <- crypto_history(limit = 1, convert="BTC")

# Retrieving market history since 2020 for ALL crypto currencies
all_coins <- crypto_history(start_date = '2020-01-01',limit=10)

# Retrieve 2015 history for all 2015 crypto currencies
coin_list_2015 <- crypto_list(only_active=TRUE) \%>\%
              dplyr::filter(first_historical_data<="2015-12-31",
              last_historical_data>="2015-01-01")
coins_2015 <- crypto_history(coin_list = coin_list_2015,
              start_date = "2015-01-01", end_date="2015-12-31", limit=20, interval="30d")
# retrieve hourly bitcoin data for 2 days
btc_hourly <- crypto_history(coin_list = coin_list_2015,
              start_date = "2015-01-01", end_date="2015-01-03", limit=1, interval="1h")

}

}
