% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symmetry.R
\name{syminfo_to_op_xyz_list}
\alias{syminfo_to_op_xyz_list}
\title{Operators of a specific space group}
\usage{
syminfo_to_op_xyz_list(SG)
}
\arguments{
\item{SG}{A character string. The extended Hermann-Mauguin symbol (e.g. 'P 1 1 21')}
}
\value{
op_xyz_list A named list made of two vectors. The first vector, SYMOP, contains strings
  describing the symmetry operators. The second vector, CENOP, contains strings describing the
  centring of the unit cell.
}
\description{
Returns human-readable symmetry operators corresponding to a specific input space group.
}
\details{
A crystallographic space group includes a set of symmetry operators that can be expressed
like operations on the (x,y,z) fractional coordinates of atoms in a unit cell. So, for example,
The only operator associated with the space group P 1 is "x,y,z", while the four operators
associated with P 21 21 21 are "symop x,y,z", "symop -x+1/2,-y,z+1/2", "symop x+1/2,-y+1/2,-z",
"symop -x,y+1/2,-z+1/2".
}
\examples{
# Symmetry operators for space group number 3, P 1 2 1
SG <- "P 1 2 1"
ltmp <- syminfo_to_op_xyz_list(SG)
ltmp

}
