% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lattice_S3.R
\name{bravais}
\alias{bravais}
\title{Constructor for an S3 object of class "bravais"}
\usage{
bravais(bt = NULL)
}
\arguments{
\item{bt}{A two-letter character, denoting the Bravais type.}
}
\value{
An object of class "bravais". It is a named list of length 4. The first slot, "bt", is
        the universally-used two-letter symbol. The second, third and fourth slots are, respectively,
        "cr_fam" (the corresponding crystal family), "cr_sys" (the corresponding crystal system) and
        "lt_sys" (the corresponding lattice system).
}
\description{
There are 14 Bravais lattices. They are represented by a two-letter symbol:
aP, mP, mS, oP, oS, oF, oI, tP, tI, hP, hR, cP, cF, cI
}
\examples{
# mS is a monoclinic, face-centred Bravais lattice
bt <- bravais("mS")
class(bt)
bt[1:4]

}
