% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symmetry.R
\name{extract_symmetry_info}
\alias{extract_symmetry_info}
\title{Information on a specific space group}
\usage{
extract_symmetry_info(SG)
}
\arguments{
\item{SG}{A character string. The extended Hermann-Mauguin symbol (e.g. 'P 1 1 21')}
}
\value{
infostring A named list with fields corresponding to those in the CCP4 symmetry
 library. The fields' name are:
 \itemize{
   \item{\strong{NUMBER} standard spacegroup number}
   \item{\strong{BASISOP} change of basis operator}
   \item{\strong{CCP4} CCP4 spacegroup number e.g. 1003 (0 if not a CCP4 group)}
   \item{\strong{HALL} Hall symbol}
   \item{\strong{xHM} extended Hermann Mauguin symbol}
   \item{\strong{OLD} CCP4 spacegroup name (blank if not a CCP4 group)}
   \item{\strong{LAUE} Laue group symbol}
   \item{\strong{PATT} Patterson group symbol}
   \item{\strong{PGRP} Point group symbol}
   \item{\strong{HKLASU} reciprocal space asymmetric unit (with respect to standard setting)}
   \item{\strong{MAPASU_CCP4} CCP4 real space asymmetric unit (with respect to standard setting.
    Negative ranges if not a CCP4 group)}
   \item{\strong{MAPASU_ZERO} origin based real space asymmetric unit (with respect to current
    setting)}
   \item{\strong{MAPASU_NONZ} non-origin based real space asymmetric uni (with respect to
    current setting)}
   \item{\strong{CHESHIRE} Cheshire cell (with respect to standard setting)}
   \item{\strong{SYMOP} list of primitive symmetry operators}
   \item{\strong{CENOP} list of centering operators}
 }
}
\description{
Returns human-readable information on a specific input space group.
}
\details{
Crystallographic symmetry is fundamental in crystallography. It affects the way
atoms are arranged in a unit cell, the pattern of reflections in reciprocal space
and many other common occurrences in crystallography. This function returns a named
list with human-readable character strings which detail key symmetry information.
}
\examples{
# This is the full information for space group number 19, P 21 21 21
SG <- translate_SG(19)
ltmp <- extract_symmetry_info(SG)
ltmp

}
