% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/automation.R
\name{runCrunchAutomation}
\alias{runCrunchAutomation}
\alias{showScriptErrors}
\title{Run a crunch automation script}
\usage{
runCrunchAutomation(
  dataset,
  script,
  is_file = string_is_file_like(script),
  encoding = "UTF-8",
  ...
)

showScriptErrors()
}
\arguments{
\item{dataset}{A crunch dataset}

\item{script}{A path to a text file with crunch automation syntax
or a string the syntax loaded in R.}

\item{is_file}{The default guesses whether a file or string was
used in the \code{script} argument, but you can override the heuristics
by specifying \code{TRUE} for a file, and \code{FALSE} for a string.}

\item{encoding}{Optional encoding to convert \strong{from}, defaults to UTF-8.
The API accepts only UTF-8, so all text will be converted to UTF-8 before
being sent to the server.}

\item{...}{Additional options, such as \code{dry_run = TRUE} passed on
to the API}
}
\value{
For \code{runCrunchAutomation()}: an updated dataset (invisibly),
For \code{showScriptErrors()}, when run after a failure, a list with two items:
\code{script}: that contains the script string sent to the server and \code{errors} which is a
\code{data.frame} with details about the errors sent from the server.
}
\description{
Crunch automation is a custom scripting syntax that allows you to
concisely describe the metadata of your data when importing. The
syntax is described \href{https://help.crunch.io/hc/en-us/categories/360004356012-Crunch-Automation}{in the crunch API documentation}
}
\examples{
\dontrun{
# Can use a path to a file:
script_file <- "crunch_automation.txt"
ds <- runCrunchAutomation(ds, script_file)

# Or a string directly:
ds <- runCrunchAutomation(ds, "RENAME v1 TO age;")

# A "dry run" that validates the script but does not run it:
runCrunchAutomation(ds, "RENAME V1 TO age;", dry_run = TRUE)

# After a failed run, some error information prints to console,
# But more details are available with function:
showScriptErrors()

# After a successful run, can look at scripts
scripts(ds)

}
}
\seealso{
\code{\link{automation-undo}} & \code{\link{script-catalog}}
}
