% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datetime.R
\name{resolution}
\alias{resolution}
\alias{resolution<-}
\alias{rollup}
\alias{rollupResolution}
\alias{rollupResolution<-}
\title{Methods for Datetime variable resolutions}
\usage{
resolution(x)

resolution(x) <- value

rollup(x, resolution = rollupResolution(x))

rollupResolution(x)

rollupResolution(x) <- value
}
\arguments{
\item{x}{a Datetime variable}

\item{value}{a resolution string. Valid resolutions in Crunch are
\code{c("Y", "Q", "M", "W", "D", "h", "m", "s", "ms")}. \code{NULL} is also valid for
\code{rollupResolution<-} but not for \code{resolution<-}.}

\item{resolution}{Same as \code{value}, in \code{rollup()}. This may be \code{NULL}, in
which case the server will determine an appropriate resolution based on the
range of the data.}
}
\value{
\code{resolution()} and \code{rollupResolution()} return the resolution string
for datetime variables, \code{NULL} otherwise. The setters return the variable
entity after modifying the state on the server. \code{rollup()} returns a
\code{CrunchExpr} expression.
}
\description{
Datetime data has a "resolution", the units of the values.
\code{resolution()} exposes that property and \code{resolution<-} lets you set it.
"Rollups" are a way of binning datetime data into meaningful units.
\code{rollup()} lets you create an expression that you can query with. Datetime
variables also have a \code{rollupResolution()} attribute that is the default
resolution they will roll-up to, if not specified in \code{rollup()};
\code{rollupResolution<-} lets you set that.
}
\details{
Note that \code{resolution} is a property of the data while \code{rollupResolution} is
metadata. Setting \code{resolution} alters the column data, and if setting a more
coarse resolution (e.g. going from "s" to "m"), it cannot be reversed.
Setting \code{rollupResolution} is non-destructive.
}
\examples{
\dontrun{
resolution(ds$starttime)
## [1] "ms"
resolution(ds$starttime) <- "s"
rollup(ds$starttime)
rollup(ds$starttime, "D")
rollupResolution(ds$starttime) <- "D"
crtabs(~ rollup(starttime), data = ds)
}
}
