% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{VariableOrder-class}
\alias{VariableOrder-class}
\alias{VariableOrder}
\alias{VariableGroup-class}
\alias{VariableGroup}
\title{Organize Variables within a Dataset}
\description{
Variables in the Crunch web application can be viewed in an ordered,
hierarchical list. These objects and methods allow you to modify that order
from R.
}
\details{
A VariableOrder object is a subclass of \code{list} that contains
VariableGroups. VariableGroup objects contain a group name and an set of
"entities", which can be variable references or other nested VariableGroups.
}
\section{Slots}{

\describe{
\item{\code{group}}{character, the name of the VariableGroup. In the constructor and
more generally, this field can be referenced as "name" as well.}

\item{\code{entities}}{a character vector of variable URLs, or a list containing a
combination of variable URLs and VariableGroup objects.}

\item{\code{duplicates}}{logical: should duplicate variable references be allowed in
this object? Default is \code{FALSE}.}

\item{\code{vars}}{either \code{NULL} or a \code{\link{VariableCatalog}}. If not
\code{NULL}, it will be used to look up variable names from the URLs.}
}}

