% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.crossnma.R
\name{summary.crossnma}
\alias{summary.crossnma}
\title{Summary function for crossnma object}
\usage{
\method{summary}{crossnma}(object, quantiles = c(0.025, 0.5, 0.975), exp = TRUE, ...)
}
\arguments{
\item{object}{An object generated by the \code{\link{crossnma}}.}

\item{quantiles}{A numeric vector of probabilities to present
posterior summaries. The default value is c(0.025, 0.5, 0.975)
for the 95\% credible interval and the median.}

\item{exp}{A logical value indicating whether to exponentiate the
parameters of relative treatment effect and covariate
effect. Default is TRUE.}

\item{\dots}{Additional arguments to be passed to summary()
function}
}
\value{
\code{crossnma.summary} returns a matrix containing the
  following summary statistics (in columns) for each estimated
  parameter:

\code{Mean} the mean of the posterior distribution

\code{SD} the standard deviation of the posterior
  distribution

\code{2.5\%} (default) the 2.5\% quantile of the posterior
  distribution (the lower bound of the 95\% credible interval)

\code{50\%} (default) the median of the posterior
  distribution

\code{97.5\%} (default) the 97.5\% quantile of the
  posterior distribution (the upper bound of the 95\% credible
  interval)

\code{Rhat} Gelman-Rubin statistic. The further the value
  of Rhat from 1, the worse the mixing of chains and so the
  convergence.

\code{n.eff} An estimate of the effective sample size. The
  smaller the value of n.eff the greater the uncertainty associated
  with the corresponding parameter.
}
\description{
This function creates posterior summary statistics for the fitted
cross network meta-analysis / meta-regression model
}
\examples{
# We conduct a network meta-analysis assuming a random-effects
# model.
# The data comes from randomized-controlled trials and
# non-randomized studies (combined naively)
head(ipddata) # participant-level data
head(stddata) # study-level data

# Create a JAGS model
mod <- crossnma.model(treat, id, relapse, n, design,
  prt.data = ipddata, std.data = stddata,
  reference = "A", trt.effect = "random", method.bias = "naive")

# Fit JAGS model
# (suppress warning 'Adaptation incomplete' due to n.adapt = 20)
fit <-
  suppressWarnings(crossnma(mod, n.adapt = 20,
    n.iter = 50, thin = 1, n.chains = 3))

# Display the output
summary(fit)

}
\seealso{
\code{\link{print.summary.crossnma}}
}
\author{
Tasnim Hamza \email{tasnim.hamza@ispm.unibe.ch}
}
