% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crop.R
\name{square_crop}
\alias{square_crop}
\title{Square crop}
\usage{
square_crop(images, to = NULL)
}
\arguments{
\item{images}{Vector of image paths, either local or urls. If urls the images
will be downloaded first.}

\item{to}{Path to new location}
}
\value{
Path to cropped images
}
\description{
Reads in an image and square crops. If a new path is given it will save the cropped images to
the new location. If no path is given it will save to a temporary location
which will be cleared when the session is closed
}
\examples{
library(magick)

x <- c(1, 3, 9, 8)
path <- "https://openpsychometrics.org/tests/characters/test-resources/pics/BB/"
img_paths <- paste0(path, x, ".jpg")

img_paths_cropped <- square_crop(img_paths)

imgs <- image_read(img_paths_cropped)
image_montage(imgs)
}
