% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model-methods.R
\name{prob}
\alias{prob}
\alias{prob,numeric,Model,Samples-method}
\alias{prob,numeric,ModelTox,Samples-method}
\alias{prob,numeric,ModelTox,missing-method}
\title{Compute the probability for a given dose, given model and samples}
\usage{
prob(dose, model, samples, ...)

\S4method{prob}{numeric,Model,Samples}(dose, model, samples, ...)

\S4method{prob}{numeric,ModelTox,Samples}(dose, model, samples, ...)

\S4method{prob}{numeric,ModelTox,missing}(dose, model, samples, ...)
}
\arguments{
\item{dose}{the dose}

\item{model}{the \code{\linkS4class{Model}} object}

\item{samples}{the \code{\linkS4class{Samples}}}

\item{\dots}{unused}
}
\value{
the vector (for \code{\linkS4class{Model}} objects) of probability
samples.
}
\description{
Compute the probability for a given dose, given model and samples
}
\section{Functions}{
\itemize{
\item \code{prob(dose = numeric, model = ModelTox, samples = Samples)}: Compute the probability for a given dose, 
given Pseudo DLE model and samples

\item \code{prob(dose = numeric, model = ModelTox, samples = missing)}: Compute the probability for a given dose, given Pseudo DLE model without samples

}}
\examples{

# create some data
data <- Data(x =c (0.1, 0.5, 1.5, 3, 6, 10, 10, 10),
             y = c(0, 0, 0, 0, 0, 0, 1, 0),
             cohort = c(0, 1, 2, 3, 4, 5, 5, 5),
             doseGrid = c(0.1, 0.5, 1.5, 3, 6,
                          seq(from=10, to=80, by=2)))

# Initialize a  model
model <- LogisticLogNormal(mean=c(-0.85, 1),
                           cov=matrix(c(1, -0.5, -0.5, 1),
                                      nrow=2),
                           refDose=56)

# Get samples from posterior
options <- McmcOptions(burnin=100,
                       step=2,
                       samples=2000)
set.seed(94)
samples <- mcmc(data, model, options)

# posterior for Prob(DLT | dose=50)
tox.prob <- prob(dose=50, model=model, samples=samples)




# create data from the 'DataDual' class
data <- DataDual(x = c(25,50,25,50,75,300,250,150),
                 y = c(0,0,0,0,0,1,1,0),
                 w = c(0.31,0.42,0.59,0.45,0.6,0.7,0.6,0.52),
                 doseGrid = seq(25,300,25))

## Initialize a model from 'ModelTox' class e.g using 'LogisticIndepBeta' model
DLEmodel <- LogisticIndepBeta(binDLE=c(1.05,1.8),
                              DLEweights=c(3,3),
                              DLEdose=c(25,300),
                              data=data)

options <- McmcOptions(burnin=100, step=2, samples=200)
DLEsamples <- mcmc(data=data,model=DLEmodel,options=options)

tox.prob <- prob(dose=100, model = DLEmodel, samples = DLEsamples)



# create data from the 'DataDual' class
data <- DataDual(x = c(25,50,25,50,75,300,250,150),
                 y = c(0,0,0,0,0,1,1,0),
                 w = c(0.31,0.42,0.59,0.45,0.6,0.7,0.6,0.52),
                 doseGrid = seq(25,300,25))

## Initialize a model from 'ModelTox' class e.g using 'LogisticIndepBeta' model
DLEmodel <- LogisticIndepBeta(binDLE=c(1.05,1.8),
                              DLEweights=c(3,3),
                              DLEdose=c(25,300),
                              data=data)

tox.prob <- prob(dose=100, model = DLEmodel)

}
\keyword{methods}
