% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model-class.R
\docType{class}
\name{DualEndpointRW-class}
\alias{DualEndpointRW-class}
\alias{.DualEndpointRW}
\title{Dual endpoint model with RW prior for biomarker}
\description{
This class extends the \code{\linkS4class{DualEndpoint}} class. Here the
dose-biomarker relationship \eqn{f(x)} is modelled by a non-parametric
random-walk of first (RW1) or second order (RW2) (todo: warning: at the
moment only the first order random walk produces useful results).
}
\details{
That means, for the RW1 we assume
\deqn{\beta_{W,i} - \beta_{W,i-1} \sim Normal(0, (x_{i} - x_{i-1}) \sigma^{2}_{\beta_{W}}),}
where \eqn{\beta_{W,i} = f(x_{i})} is the biomarker mean at the i-th dose
gridpoint \eqn{x_{i}}.
For the RW2, the second-order differences instead of the first-order
differences of the biomarker means follow the normal distribution.

The variance parameter \eqn{\sigma^{2}_{\beta_{W}}} is important because it
steers the smoothness of the function f(x): if it is large, then f(x) will
be very wiggly; if it is small, then f(x) will be smooth. This parameter can
either be fixed or assigned an inverse gamma prior distribution.

Non-equidistant dose grids can be used now, because the difference
\eqn{x_{i} - x_{i-1}} is included in the modelling assumption above.

Please note that due to impropriety of the RW prior distributions, it is 
not possible to produce MCMC samples with empty data objects (i.e., sample
from the prior). This is not a bug, but a theoretical feature of this
model.
}
\section{Slots}{

\describe{
\item{\code{sigma2betaW}}{Contains the prior variance factor of the random walk
prior for the biomarker model. If it is not a single number, it can also
contain a vector with elements \code{a} and {b} for the inverse-gamma prior
on \code{sigma2betaW}.}

\item{\code{useRW1}}{for specifying the random walk prior on the biomarker level: if
\code{TRUE}, RW1 is used, otherwise RW2.}
}}

\examples{


model <- DualEndpointRW(mu = c(0, 1),
                        Sigma = matrix(c(1, 0, 0, 1), nrow=2),
                        sigma2betaW = 0.01,
                        sigma2W = c(a=0.1, b=0.1),
                        rho = c(a=1, b=1),
                        smooth="RW1")


}
\keyword{classes}
