% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{make_desc_stats_table}
\alias{make_desc_stats_table}
\title{Create a descriptive statistics table from numeric variables}
\usage{
make_desc_stats_table(
  data,
  columns,
  output = c("min", "median", "mean", "sd", "max", "sum", "NAs"),
  decimals = 2,
  title = NULL,
  subtitle = NULL,
  footnote = NULL
)
}
\arguments{
\item{data}{A data.frame with the data you want to make the table from.}

\item{columns}{A string or vector of strings with the names of the columns you want to use.}

\item{output}{A string or vector of strings indicating which math functions you want to
perform on the columns and present in the table. Options are: 'min',
'median', 'mean', 'sd', 'max', and 'N'. Default is to use all of these
math functions. The order you put in these values is the order
the table will present the columns.}

\item{decimals}{A positive integer for how many decimal places you want to round to.}

\item{title}{A string with the text you want as the title}

\item{subtitle}{A string with the text you want as the subtitle.}

\item{footnote}{A string with the text you want as the footnote.}
}
\value{
A data.frame with the data that generates the table, which is outputted
in the Viewer tab.
}
\description{
Create a descriptive statistics table from numeric variables
}
\examples{
make_desc_stats_table(mtcars, columns = c("mpg", "disp", "wt", "cyl"))

make_desc_stats_table(mtcars, c("mpg", "disp", "wt"), output = c("mean", "min"),
decimals = 4, title = "hello", subtitle = "world")
}
