% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_controller_group.R
\name{crew_class_controller_group}
\alias{crew_class_controller_group}
\title{Controller group class}
\description{
\code{R6} class for controller groups.
}
\details{
See \code{\link[=crew_controller_group]{crew_controller_group()}}.
}
\examples{
if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
persistent <- crew_controller_local(name = "persistent")
transient <- crew_controller_local(
  name = "transient",
  tasks_max = 1L
)
group <- crew_controller_group(persistent, transient)
group$start()
group$push(name = "task", command = sqrt(4), controller = "transient")
group$wait()
group$pop()
group$terminate()
}

## ------------------------------------------------
## Method `crew_class_controller_group$new`
## ------------------------------------------------

if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
persistent <- crew_controller_local(name = "persistent")
transient <- crew_controller_local(
  name = "transient",
  tasks_max = 1L
)
group <- crew_controller_group(persistent, transient)
group$start()
group$push(name = "task", command = sqrt(4), controller = "transient")
group$wait()
group$pop()
group$terminate()
}
}
\seealso{
Other controller_group: 
\code{\link{crew_controller_group}()}
}
\concept{controller_group}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{controllers}}{List of \code{R6} controller objects.}

\item{\code{relay}}{Relay object for event-driven programming on a downstream
condition variable.}

\item{\code{throttle}}{\code{\link[=crew_throttle]{crew_throttle()}} object to orchestrate exponential
backoff in the relay and auto-scaling.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-crew_class_controller_group-new}{\code{crew_class_controller_group$new()}}
\item \href{#method-crew_class_controller_group-validate}{\code{crew_class_controller_group$validate()}}
\item \href{#method-crew_class_controller_group-empty}{\code{crew_class_controller_group$empty()}}
\item \href{#method-crew_class_controller_group-nonempty}{\code{crew_class_controller_group$nonempty()}}
\item \href{#method-crew_class_controller_group-resolved}{\code{crew_class_controller_group$resolved()}}
\item \href{#method-crew_class_controller_group-unresolved}{\code{crew_class_controller_group$unresolved()}}
\item \href{#method-crew_class_controller_group-unpopped}{\code{crew_class_controller_group$unpopped()}}
\item \href{#method-crew_class_controller_group-saturated}{\code{crew_class_controller_group$saturated()}}
\item \href{#method-crew_class_controller_group-start}{\code{crew_class_controller_group$start()}}
\item \href{#method-crew_class_controller_group-started}{\code{crew_class_controller_group$started()}}
\item \href{#method-crew_class_controller_group-launch}{\code{crew_class_controller_group$launch()}}
\item \href{#method-crew_class_controller_group-scale}{\code{crew_class_controller_group$scale()}}
\item \href{#method-crew_class_controller_group-autoscale}{\code{crew_class_controller_group$autoscale()}}
\item \href{#method-crew_class_controller_group-descale}{\code{crew_class_controller_group$descale()}}
\item \href{#method-crew_class_controller_group-crashes}{\code{crew_class_controller_group$crashes()}}
\item \href{#method-crew_class_controller_group-push}{\code{crew_class_controller_group$push()}}
\item \href{#method-crew_class_controller_group-walk}{\code{crew_class_controller_group$walk()}}
\item \href{#method-crew_class_controller_group-map}{\code{crew_class_controller_group$map()}}
\item \href{#method-crew_class_controller_group-pop}{\code{crew_class_controller_group$pop()}}
\item \href{#method-crew_class_controller_group-collect}{\code{crew_class_controller_group$collect()}}
\item \href{#method-crew_class_controller_group-promise}{\code{crew_class_controller_group$promise()}}
\item \href{#method-crew_class_controller_group-wait}{\code{crew_class_controller_group$wait()}}
\item \href{#method-crew_class_controller_group-push_backlog}{\code{crew_class_controller_group$push_backlog()}}
\item \href{#method-crew_class_controller_group-pop_backlog}{\code{crew_class_controller_group$pop_backlog()}}
\item \href{#method-crew_class_controller_group-summary}{\code{crew_class_controller_group$summary()}}
\item \href{#method-crew_class_controller_group-pids}{\code{crew_class_controller_group$pids()}}
\item \href{#method-crew_class_controller_group-terminate}{\code{crew_class_controller_group$terminate()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-new"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-new}{}}}
\subsection{Method \code{new()}}{
Multi-controller constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$new(
  controllers = NULL,
  relay = NULL,
  throttle = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{controllers}}{List of \code{R6} controller objects.}

\item{\code{relay}}{Relay object for event-driven programming on a downstream
condition variable.}

\item{\code{throttle}}{\code{\link[=crew_throttle]{crew_throttle()}} object to orchestrate exponential
backoff in the relay and auto-scaling.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An \code{R6} object with the controller group object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
persistent <- crew_controller_local(name = "persistent")
transient <- crew_controller_local(
  name = "transient",
  tasks_max = 1L
)
group <- crew_controller_group(persistent, transient)
group$start()
group$push(name = "task", command = sqrt(4), controller = "transient")
group$wait()
group$pop()
group$terminate()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-validate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-validate}{}}}
\subsection{Method \code{validate()}}{
Validate the client.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$validate()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-empty"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-empty}{}}}
\subsection{Method \code{empty()}}{
See if the controllers are empty.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$empty(controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{controllers}}{Character vector of controller names.
Set to \code{NULL} to select all controllers.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
A controller is empty if it has no running tasks
or completed tasks waiting to be retrieved with \code{push()}.
}

\subsection{Returns}{
\code{TRUE} if all the selected controllers are empty,
\code{FALSE} otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-nonempty"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-nonempty}{}}}
\subsection{Method \code{nonempty()}}{
Check if the controller group is nonempty.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$nonempty(controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{controllers}}{Character vector of controller names.
Set to \code{NULL} to select all controllers.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
A controller is empty if it has no running tasks
or completed tasks waiting to be retrieved with \code{push()}.
}

\subsection{Returns}{
\code{TRUE} if the controller is empty, \code{FALSE} otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-resolved"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-resolved}{}}}
\subsection{Method \code{resolved()}}{
Number of resolved \code{mirai()} tasks.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$resolved(controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{controllers}}{Character vector of controller names.
Set to \code{NULL} to select all controllers.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\code{resolved()} is cumulative: it counts all the resolved
tasks over the entire lifetime of the controller session.
}

\subsection{Returns}{
Non-negative integer of length 1,
number of resolved \code{mirai()} tasks.
The return value is 0 if the condition variable does not exist
(i.e. if the client is not running).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-unresolved"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-unresolved}{}}}
\subsection{Method \code{unresolved()}}{
Number of unresolved \code{mirai()} tasks.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$unresolved(controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{controllers}}{Character vector of controller names.
Set to \code{NULL} to select all controllers.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Non-negative integer of length 1,
number of unresolved \code{mirai()} tasks.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-unpopped"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-unpopped}{}}}
\subsection{Method \code{unpopped()}}{
Number of resolved \code{mirai()} tasks available via \code{pop()}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$unpopped(controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{controllers}}{Character vector of controller names.
Set to \code{NULL} to select all controllers.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Non-negative integer of length 1,
number of resolved \code{mirai()} tasks available via \code{pop()}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-saturated"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-saturated}{}}}
\subsection{Method \code{saturated()}}{
Check if a controller is saturated.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$saturated(
  collect = NULL,
  throttle = NULL,
  controller = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{collect}}{Deprecated in version 0.5.0.9003 (2023-10-02). Not used.}

\item{\code{throttle}}{Deprecated in version 0.5.0.9003 (2023-10-02). Not used.}

\item{\code{controller}}{Character vector of length 1 with the controller name.
Set to \code{NULL} to select the default controller that \code{push()}
would choose.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
A controller is saturated if the number of unresolved tasks
is greater than or equal to the maximum number of workers.
In other words, in a saturated controller, every available worker
has a task.
You can still push tasks to a saturated controller, but
tools that use \code{crew} such as \code{targets} may choose not to.
}

\subsection{Returns}{
\code{TRUE} if all the selected controllers are saturated,
\code{FALSE} otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-start"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-start}{}}}
\subsection{Method \code{start()}}{
Start one or more controllers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$start(controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{controllers}}{Character vector of controller names.
Set to \code{NULL} to select all controllers.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-started"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-started}{}}}
\subsection{Method \code{started()}}{
Check whether all the given controllers are started.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$started(controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{controllers}}{Character vector of controller names.
Set to \code{NULL} to select all controllers.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Actually checks whether all the given clients are started.
}

\subsection{Returns}{
\code{TRUE} if the controllers are started, \code{FALSE} if any are not.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-launch"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-launch}{}}}
\subsection{Method \code{launch()}}{
Launch one or more workers on one or more controllers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$launch(n = 1L, controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Number of workers to launch in each controller selected.}

\item{\code{controllers}}{Character vector of controller names.
Set to \code{NULL} to select all controllers.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-scale"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-scale}{}}}
\subsection{Method \code{scale()}}{
Automatically scale up the number of workers if needed
in one or more controller objects.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$scale(throttle = TRUE, controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{throttle}}{\code{TRUE} to skip auto-scaling if it already happened
within the last \code{seconds_interval} seconds. \code{FALSE} to auto-scale
every time \code{scale()} is called. Throttling avoids
overburdening the \code{mirai} dispatcher and other resources.}

\item{\code{controllers}}{Character vector of controller names.
Set to \code{NULL} to select all controllers.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See the \code{scale()} method in individual controller classes.
}

\subsection{Returns}{
Invisibly returns \code{TRUE} if there was any relevant
auto-scaling activity (new worker launches or worker
connection/disconnection events) (\code{FALSE} otherwise).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-autoscale"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-autoscale}{}}}
\subsection{Method \code{autoscale()}}{
Run worker auto-scaling in a private \code{later} loop
every \code{controller$client$seconds_interval} seconds.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$autoscale(controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{controllers}}{Character vector of controller names.
Set to \code{NULL} to select all controllers.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-descale"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-descale}{}}}
\subsection{Method \code{descale()}}{
Terminate the auto-scaling loop started by
\code{controller$autoscale()}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$descale(controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{controllers}}{Character vector of controller names.
Set to \code{NULL} to select all controllers.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-crashes"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-crashes}{}}}
\subsection{Method \code{crashes()}}{
Report the number of consecutive crashes of a task,
summed over all selected controllers in the group.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$crashes(name, controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Character string, name of the task to check.}

\item{\code{controllers}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See the \code{crashes_max} argument of \code{\link[=crew_controller]{crew_controller()}}.
}

\subsection{Returns}{
Number of consecutive crashes of the named task,
summed over all the controllers in the group.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-push"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-push}{}}}
\subsection{Method \code{push()}}{
Push a task to the head of the task list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$push(
  command,
  data = list(),
  globals = list(),
  substitute = TRUE,
  seed = NULL,
  algorithm = NULL,
  packages = character(0),
  library = NULL,
  seconds_timeout = NULL,
  scale = TRUE,
  throttle = TRUE,
  name = NULL,
  save_command = NULL,
  controller = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{command}}{Language object with R code to run.}

\item{\code{data}}{Named list of local data objects in the
evaluation environment.}

\item{\code{globals}}{Named list of objects to temporarily assign to the
global environment for the task. See the \code{reset_globals}
argument of \code{\link[=crew_controller_local]{crew_controller_local()}}.}

\item{\code{substitute}}{Logical of length 1, whether to call
\code{base::substitute()} on the supplied value of the
\code{command} argument. If \code{TRUE} (default) then \code{command} is quoted
literally as you write it, e.g.
\code{push(command = your_function_call())}. If \code{FALSE}, then \code{crew}
assumes \code{command} is a language object and you are passing its
value, e.g. \code{push(command = quote(your_function_call()))}.
\code{substitute = TRUE} is appropriate for interactive use,
whereas \code{substitute = FALSE} is meant for automated R programs
that invoke \code{crew} controllers.}

\item{\code{seed}}{Integer of length 1 with the pseudo-random number generator
seed to set for the evaluation of the task. Passed to the
\code{seed} argument of \code{set.seed()} if not \code{NULL}.
If \code{algorithm} and \code{seed} are both \code{NULL},
then the random number generator defaults to the
widely spaced worker-specific
L'Ecuyer streams as supported by \code{mirai::nextstream()}.
See \code{vignette("parallel", package = "parallel")} for details.}

\item{\code{algorithm}}{Integer of length 1 with the pseudo-random number
generator algorithm to set for the evaluation of the task.
Passed to the \code{kind} argument of \code{RNGkind()} if not \code{NULL}.
If \code{algorithm} and \code{seed} are both \code{NULL},
then the random number generator defaults to the
recommended widely spaced worker-specific
L'Ecuyer streams as supported by \code{mirai::nextstream()}.
See \code{vignette("parallel", package = "parallel")} for details.}

\item{\code{packages}}{Character vector of packages to load for the task.}

\item{\code{library}}{Library path to load the packages. See the \code{lib.loc}
argument of \code{require()}.}

\item{\code{seconds_timeout}}{Optional task timeout passed to the \code{.timeout}
argument of \code{mirai::mirai()} (after converting to milliseconds).}

\item{\code{scale}}{Logical, whether to automatically scale workers to meet
demand. See the \code{scale} argument of the \code{push()} method of
ordinary single controllers.}

\item{\code{throttle}}{\code{TRUE} to skip auto-scaling if it already happened
within the last \code{seconds_interval} seconds. \code{FALSE} to auto-scale
every time \code{scale()} is called. Throttling avoids
overburdening the \code{mirai} dispatcher and other resources.}

\item{\code{name}}{Character string, name of the task. If \code{NULL},
a random name is automatically generated.
The task name must not conflict with an existing task
in the controller where it is submitted.
To reuse the name, wait for the existing task
to finish, then either \code{pop()} or \code{collect()} it
to remove it from its controller.}

\item{\code{save_command}}{Deprecated on 2025-01-22
(\code{crew} version 0.10.2.9004).}

\item{\code{controller}}{Character of length 1,
name of the controller to submit the task.
If \code{NULL}, the controller defaults to the
first controller in the list.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisibly return the \code{mirai} object of the pushed task.
This allows you to interact with the task directly, e.g.
to create a promise object with \code{promises::as.promise()}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-walk"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-walk}{}}}
\subsection{Method \code{walk()}}{
Apply a single command to multiple inputs,
and return control to the user without
waiting for any task to complete.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$walk(
  command,
  iterate,
  data = list(),
  globals = list(),
  substitute = TRUE,
  seed = NULL,
  algorithm = NULL,
  packages = character(0),
  library = NULL,
  seconds_timeout = NULL,
  names = NULL,
  save_command = NULL,
  verbose = interactive(),
  scale = TRUE,
  throttle = TRUE,
  controller = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{command}}{Language object with R code to run.}

\item{\code{iterate}}{Named list of vectors or lists to iterate over.
For example, to run function calls
\code{f(x = 1, y = "a")} and \code{f(x = 2, y = "b")},
set \code{command} to \code{f(x, y)}, and set \code{iterate} to
\code{list(x = c(1, 2), y = c("a", "b"))}. The individual
function calls are evaluated as
\code{f(x = iterate$x[[1]], y = iterate$y[[1]])} and
\code{f(x = iterate$x[[2]], y = iterate$y[[2]])}.
All the elements of \code{iterate} must have the same length.
If there are any name conflicts between \code{iterate} and \code{data},
\code{iterate} takes precedence.}

\item{\code{data}}{Named list of constant local data objects in the
evaluation environment. Objects in this list are treated as single
values and are held constant for each iteration of the map.}

\item{\code{globals}}{Named list of constant objects to temporarily
assign to the global environment for each task. This list should
include any functions you previously defined in the global
environment which are required to run tasks.
See the \code{reset_globals} argument of \code{\link[=crew_controller_local]{crew_controller_local()}}.
Objects in this list are treated as single
values and are held constant for each iteration of the map.}

\item{\code{substitute}}{Logical of length 1, whether to call
\code{base::substitute()} on the supplied value of the
\code{command} argument. If \code{TRUE} (default) then \code{command} is quoted
literally as you write it, e.g.
\code{push(command = your_function_call())}. If \code{FALSE}, then \code{crew}
assumes \code{command} is a language object and you are passing its
value, e.g. \code{push(command = quote(your_function_call()))}.
\code{substitute = TRUE} is appropriate for interactive use,
whereas \code{substitute = FALSE} is meant for automated R programs
that invoke \code{crew} controllers.}

\item{\code{seed}}{Integer of length 1 with the pseudo-random number generator
seed to set for the evaluation of the task. Passed to the
\code{seed} argument of \code{set.seed()} if not \code{NULL}.
If \code{algorithm} and \code{seed} are both \code{NULL},
then the random number generator defaults to the
recommended widely spaced worker-specific
L'Ecuyer streams as supported by \code{mirai::nextstream()}.
See \code{vignette("parallel", package = "parallel")} for details.}

\item{\code{algorithm}}{Integer of length 1 with the pseudo-random number
generator algorithm to set for the evaluation of the task.
Passed to the \code{kind} argument of \code{RNGkind()} if not \code{NULL}.
If \code{algorithm} and \code{seed} are both \code{NULL},
then the random number generator defaults to the
recommended widely spaced worker-specific
L'Ecuyer streams as supported by \code{mirai::nextstream()}.
See \code{vignette("parallel", package = "parallel")} for details.}

\item{\code{packages}}{Character vector of packages to load for the task.}

\item{\code{library}}{Library path to load the packages. See the \code{lib.loc}
argument of \code{require()}.}

\item{\code{seconds_timeout}}{Optional task timeout passed to the \code{.timeout}
argument of \code{mirai::mirai()} (after converting to milliseconds).}

\item{\code{names}}{Optional character of length 1, name of the element of
\code{iterate} with names for the tasks. If \code{names} is supplied,
then \code{iterate[[names]]} must be a character vector.}

\item{\code{save_command}}{Deprecated on 2025-01-22
(\code{crew} version 0.10.2.9004).}

\item{\code{verbose}}{Logical of length 1, whether to print to a progress bar
when pushing tasks.}

\item{\code{scale}}{Logical, whether to automatically scale workers to meet
demand. See also the \code{throttle} argument.}

\item{\code{throttle}}{\code{TRUE} to skip auto-scaling if it already happened
within the last \code{seconds_interval} seconds. \code{FALSE} to auto-scale
every time \code{scale()} is called. Throttling avoids
overburdening the \code{mirai} dispatcher and other resources.}

\item{\code{controller}}{Character of length 1,
name of the controller to submit the tasks.
If \code{NULL}, the controller defaults to the
first controller in the list.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
In contrast to \code{walk()}, \code{map()} blocks the local R session
and waits for all tasks to complete.
}

\subsection{Returns}{
Invisibly returns a list of \code{mirai} task objects for the
newly created tasks. The order of tasks in the list matches the
order of data in the \code{iterate} argument.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-map"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-map}{}}}
\subsection{Method \code{map()}}{
Apply a single command to multiple inputs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$map(
  command,
  iterate,
  data = list(),
  globals = list(),
  substitute = TRUE,
  seed = NULL,
  algorithm = NULL,
  packages = character(0),
  library = NULL,
  seconds_interval = NULL,
  seconds_timeout = NULL,
  names = NULL,
  save_command = NULL,
  error = "stop",
  warnings = TRUE,
  verbose = interactive(),
  scale = TRUE,
  throttle = TRUE,
  controller = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{command}}{Language object with R code to run.}

\item{\code{iterate}}{Named list of vectors or lists to iterate over.
For example, to run function calls
\code{f(x = 1, y = "a")} and \code{f(x = 2, y = "b")},
set \code{command} to \code{f(x, y)}, and set \code{iterate} to
\code{list(x = c(1, 2), y = c("a", "b"))}. The individual
function calls are evaluated as
\code{f(x = iterate$x[[1]], y = iterate$y[[1]])} and
\code{f(x = iterate$x[[2]], y = iterate$y[[2]])}.
All the elements of \code{iterate} must have the same length.
If there are any name conflicts between \code{iterate} and \code{data},
\code{iterate} takes precedence.}

\item{\code{data}}{Named list of constant local data objects in the
evaluation environment. Objects in this list are treated as single
values and are held constant for each iteration of the map.}

\item{\code{globals}}{Named list of constant objects to temporarily
assign to the global environment for each task. This list should
include any functions you previously defined in the global
environment which are required to run tasks.
See the \code{reset_globals} argument of \code{\link[=crew_controller_local]{crew_controller_local()}}.
Objects in this list are treated as single
values and are held constant for each iteration of the map.}

\item{\code{substitute}}{Logical of length 1, whether to call
\code{base::substitute()} on the supplied value of the
\code{command} argument. If \code{TRUE} (default) then \code{command} is quoted
literally as you write it, e.g.
\code{push(command = your_function_call())}. If \code{FALSE}, then \code{crew}
assumes \code{command} is a language object and you are passing its
value, e.g. \code{push(command = quote(your_function_call()))}.
\code{substitute = TRUE} is appropriate for interactive use,
whereas \code{substitute = FALSE} is meant for automated R programs
that invoke \code{crew} controllers.}

\item{\code{seed}}{Integer of length 1 with the pseudo-random number generator
seed to set for the evaluation of the task. Passed to the
\code{seed} argument of \code{set.seed()} if not \code{NULL}.
If \code{algorithm} and \code{seed} are both \code{NULL},
then the random number generator defaults to the
recommended widely spaced worker-specific
L'Ecuyer streams as supported by \code{mirai::nextstream()}.
See \code{vignette("parallel", package = "parallel")} for details.}

\item{\code{algorithm}}{Integer of length 1 with the pseudo-random number
generator algorithm to set for the evaluation of the task.
Passed to the \code{kind} argument of \code{RNGkind()} if not \code{NULL}.
If \code{algorithm} and \code{seed} are both \code{NULL},
then the random number generator defaults to the
recommended widely spaced worker-specific
L'Ecuyer streams as supported by \code{mirai::nextstream()}.
See \code{vignette("parallel", package = "parallel")} for details.}

\item{\code{packages}}{Character vector of packages to load for the task.}

\item{\code{library}}{Library path to load the packages. See the \code{lib.loc}
argument of \code{require()}.}

\item{\code{seconds_interval}}{Deprecated on 2025-01-17 (\code{crew} version
0.10.2.9003). Instead, the \code{seconds_interval} argument passed
to \code{\link[=crew_controller_group]{crew_controller_group()}} is used as \code{seconds_max}
in a \code{\link[=crew_throttle]{crew_throttle()}} object which orchestrates exponential
backoff.}

\item{\code{seconds_timeout}}{Optional task timeout passed to the \code{.timeout}
argument of \code{mirai::mirai()} (after converting to milliseconds).}

\item{\code{names}}{Optional character of length 1, name of the element of
\code{iterate} with names for the tasks. If \code{names} is supplied,
then \code{iterate[[names]]} must be a character vector.}

\item{\code{save_command}}{Deprecated on 2025-01-22
(\code{crew} version 0.10.2.9004).}

\item{\code{error}}{Character vector of length 1, choice of action if
a task has an error. Possible values:
\itemize{
\item \code{"stop"}: throw an error in the main R session instead of returning
a value. In case of an error, the results from the last errored
\code{map()} are in the \code{error} field
of the controller, e.g. \code{controller_object$error}. To reduce
memory consumption, set \code{controller_object$error <- NULL} after
you are finished troubleshooting.
\item \code{"warn"}: throw a warning. This allows the return value with
all the error messages and tracebacks to be generated.
\item \code{"silent"}: do nothing special.
}}

\item{\code{warnings}}{Logical of length 1, whether to throw a warning in the
interactive session if at least one task encounters an error.}

\item{\code{verbose}}{Logical of length 1, whether to print progress messages.}

\item{\code{scale}}{Logical, whether to automatically scale workers to meet
demand. See also the \code{throttle} argument.}

\item{\code{throttle}}{\code{TRUE} to skip auto-scaling if it already happened
within the last \code{seconds_interval} seconds. \code{FALSE} to auto-scale
every time \code{scale()} is called. Throttling avoids
overburdening the \code{mirai} dispatcher and other resources.}

\item{\code{controller}}{Character of length 1,
name of the controller to submit the tasks.
If \code{NULL}, the controller defaults to the
first controller in the list.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The idea comes from functional programming: for example,
the \code{map()} function from the \code{purrr} package.
}

\subsection{Returns}{
A \code{tibble} of results and metadata: one row per task and
columns corresponding to the output of \code{pop()}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-pop"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-pop}{}}}
\subsection{Method \code{pop()}}{
Pop a completed task from the results data frame.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$pop(
  scale = TRUE,
  collect = NULL,
  throttle = TRUE,
  error = NULL,
  controllers = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{scale}}{Logical, whether to automatically scale workers to meet
demand. See the \code{scale} argument of the \code{pop()} method of
ordinary single controllers.}

\item{\code{collect}}{Deprecated in version 0.5.0.9003 (2023-10-02). Not used.}

\item{\code{throttle}}{\code{TRUE} to skip auto-scaling if it already happened
within the last \code{seconds_interval} seconds. \code{FALSE} to auto-scale
every time \code{scale()} is called. Throttling avoids
overburdening the \code{mirai} dispatcher and other resources.}

\item{\code{error}}{\code{NULL} or character of length 1, choice of action if
the popped task threw an error. Possible values:
\itemize{
\item \code{"stop"}: throw an error in the main R session instead of returning
a value.
\item \code{"warn"}: throw a warning.
\item \code{NULL} or \code{"silent"}: do not react to errors.
}}

\item{\code{controllers}}{Character vector of controller names.
Set to \code{NULL} to select all controllers.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
If there is no task to collect, return \code{NULL}. Otherwise,
return a one-row \code{tibble} with the same columns as \code{pop()}
for ordinary controllers.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-collect"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-collect}{}}}
\subsection{Method \code{collect()}}{
Pop all available task results and return them in a tidy
\code{tibble}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$collect(
  scale = TRUE,
  throttle = TRUE,
  error = NULL,
  controllers = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{scale}}{Logical of length 1,
whether to automatically call \code{scale()}
to auto-scale workers to meet the demand of the task load.}

\item{\code{throttle}}{\code{TRUE} to skip auto-scaling if it already happened
within the last \code{seconds_interval} seconds. \code{FALSE} to auto-scale
every time \code{scale()} is called. Throttling avoids
overburdening the \code{mirai} dispatcher and other resources.}

\item{\code{error}}{\code{NULL} or character of length 1, choice of action if
the popped task threw an error. Possible values:
\itemize{
\item \code{"stop"}: throw an error in the main R session instead of returning
a value.
\item \code{"warn"}: throw a warning.
\item \code{NULL} or \code{"silent"}: do not react to errors.
}}

\item{\code{controllers}}{Character vector of controller names.
Set to \code{NULL} to select all controllers.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{tibble} of results and metadata of all resolved tasks,
with one row per task. Returns \code{NULL} if there are no available
results.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-promise"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-promise}{}}}
\subsection{Method \code{promise()}}{
Create a \code{promises::promise()} object to asynchronously
pop or collect one or more tasks.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$promise(
  mode = "one",
  seconds_interval = 0.1,
  scale = NULL,
  throttle = NULL,
  controllers = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mode}}{Character of length 1, what kind of promise to create.
\code{mode} must be \code{"one"} or \code{"all"}. Details:
\itemize{
\item If \code{mode} is \code{"one"}, then the promise is fulfilled (or rejected)
when at least one task is resolved and available to \code{pop()}.
When that happens, \code{pop()} runs asynchronously, pops a result off
the task list, and returns a value.
If the task succeeded, then the promise
is fulfilled and its value is the result of \code{pop()} (a one-row
\code{tibble} with the result and metadata). If the task threw an error,
the error message of the task is forwarded to any error callbacks
registered with the promise.
\item If \code{mode} is \code{"all"}, then the promise is fulfilled (or rejected)
when there are no unresolved tasks left in the controller.
(Be careful: this condition is trivially met in the moment
if the controller is empty and you have not submitted any tasks,
so it is best to create this kind of promise only after you
submit tasks.)
When there are no unresolved tasks left,
\code{collect()} runs asynchronously, pops all available results
off the task list, and returns a value.
If the task succeeded, then the promise
is fulfilled and its value is the result of \code{collect()}
(a \code{tibble} with one row per task result). If any of the tasks
threw an error, then the first error message detected is forwarded
to any error callbacks registered with the promise.
}}

\item{\code{seconds_interval}}{Positive numeric of length 1, delay in the
\code{later::later()} polling interval to asynchronously check if
the promise can be resolved.}

\item{\code{scale}}{Deprecated on 2024-04-10 (version 0.9.1.9003)
and no longer used. Now, \code{promise()} always turns on auto-scaling
in a private \code{later} loop (if not already activated).}

\item{\code{throttle}}{Deprecated on 2024-04-10 (version 0.9.1.9003)
and no longer used. Now, \code{promise()} always turns on auto-scaling
in a private \code{later} loop (if not already activated).}

\item{\code{controllers}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Please be aware that \code{pop()} or \code{collect()} will happen
asynchronously at a some unpredictable time after the promise object
is created, even if your local R process appears to be doing
something completely different. This behavior is highly desirable
in a Shiny reactive context, but please be careful as it may be
surprising in other situations.
}

\subsection{Returns}{
A \code{promises::promise()} object whose eventual value will
be a \code{tibble} with results from one or more popped tasks.
If \code{mode = "one"}, only one task is popped and returned (one row).
If \code{mode = "all"}, then all the tasks are returned in a \code{tibble}
with one row per task (or \code{NULL} is returned if there are no
tasks to pop).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-wait"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-wait}{}}}
\subsection{Method \code{wait()}}{
Wait for tasks.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$wait(
  mode = "all",
  seconds_interval = NULL,
  seconds_timeout = Inf,
  scale = TRUE,
  throttle = TRUE,
  controllers = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mode}}{Character of length 1: \code{"all"} to wait for
all tasks in all controllers to complete, \code{"one"} to wait for
a single task in a single controller to complete. In this scheme,
the timeout limit is applied to each controller sequentially,
and a timeout is treated the same as a completed controller.}

\item{\code{seconds_interval}}{Deprecated on 2025-01-17 (\code{crew} version
0.10.2.9003). Instead, the \code{seconds_interval} argument passed
to \code{\link[=crew_controller_group]{crew_controller_group()}} is used as \code{seconds_max}
in a \code{\link[=crew_throttle]{crew_throttle()}} object which orchestrates exponential
backoff.}

\item{\code{seconds_timeout}}{Timeout length in seconds waiting for
results to become available.}

\item{\code{scale}}{Logical of length 1, whether to call \code{scale_later()}
on each selected controller to schedule auto-scaling.
See the \code{scale} argument of the \code{wait()} method of
ordinary single controllers.}

\item{\code{throttle}}{\code{TRUE} to skip auto-scaling if it already happened
within the last \code{seconds_interval} seconds. \code{FALSE} to auto-scale
every time \code{scale()} is called. Throttling avoids
overburdening the \code{mirai} dispatcher and other resources.}

\item{\code{controllers}}{Character vector of controller names.
Set to \code{NULL} to select all controllers.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The \code{wait()} method blocks the calling R session and
repeatedly auto-scales workers for tasks that need them.
The function runs until it either times out or the condition
in \code{mode} is met.
}

\subsection{Returns}{
A logical of length 1, invisibly. \code{TRUE} if the condition
in \code{mode} was met, \code{FALSE} otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-push_backlog"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-push_backlog}{}}}
\subsection{Method \code{push_backlog()}}{
Push the name of a task to the backlog.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$push_backlog(name, controller = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Character of length 1 with the task name to push to
the backlog.}

\item{\code{controller}}{Character vector of length 1 with the controller name.
Set to \code{NULL} to select the default controller that \code{push_backlog()}
would choose.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\code{pop_backlog()} pops the tasks that can be pushed
without saturating the controller.
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-pop_backlog"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-pop_backlog}{}}}
\subsection{Method \code{pop_backlog()}}{
Pop the task names from the head of the backlog which
can be pushed without saturating the controller.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$pop_backlog(controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{controllers}}{Character vector of controller names.
Set to \code{NULL} to select all controllers.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Character vector of task names which can be pushed to the
controller without saturating it. If the controller is saturated,
\code{character(0L)} is returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-summary"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-summary}{}}}
\subsection{Method \code{summary()}}{
Summarize the workers of one or more controllers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$summary(controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{controllers}}{Character vector of controller names.
Set to \code{NULL} to select all controllers.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data frame of aggregated worker summary statistics
of all the selected controllers. It has one row per worker,
and the rows are grouped by controller.
See the documentation of the \code{summary()} method of the controller
class for specific information about the columns in the output.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-pids"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-pids}{}}}
\subsection{Method \code{pids()}}{
Get the process IDs of the local process and the
\code{mirai} dispatchers (if started).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$pids(controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{controllers}}{Character vector of controller names.
Set to \code{NULL} to select all controllers.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An integer vector of process IDs of the local process and the
\code{mirai} dispatcher (if started).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-terminate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-terminate}{}}}
\subsection{Method \code{terminate()}}{
Terminate the workers and disconnect the client
for one or more controllers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$terminate(controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{controllers}}{Character vector of controller names.
Set to \code{NULL} to select all controllers.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
}
