% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_launcher_lsf.R
\name{crew_launcher_lsf}
\alias{crew_launcher_lsf}
\title{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Create a launcher with
LSF workers.}
\usage{
crew_launcher_lsf(
  name = NULL,
  seconds_interval = 0.5,
  seconds_timeout = 60,
  seconds_launch = 86400,
  seconds_idle = Inf,
  seconds_wall = Inf,
  tasks_max = Inf,
  tasks_timers = 0L,
  reset_globals = TRUE,
  reset_packages = FALSE,
  reset_options = FALSE,
  garbage_collection = FALSE,
  launch_max = 5L,
  tls = crew::crew_tls(mode = "automatic"),
  verbose = FALSE,
  command_submit = as.character(Sys.which("bsub")),
  command_terminate = as.character(Sys.which("bkill")),
  command_delete = NULL,
  script_directory = tempdir(),
  script_lines = character(0L),
  lsf_cwd = getwd(),
  lsf_log_output = "/dev/null",
  lsf_log_error = "/dev/null",
  lsf_memory_gigabytes_limit = NULL,
  lsf_memory_gigabytes_required = NULL,
  lsf_cores = NULL
)
}
\arguments{
\item{name}{Name of the launcher.}

\item{seconds_interval}{Number of seconds between
polling intervals waiting for certain internal
synchronous operations to complete,
such as checking \code{mirai::status()}.}

\item{seconds_timeout}{Number of seconds until timing
out while waiting for certain synchronous operations to complete,
such as checking \code{mirai::status()}.}

\item{seconds_launch}{Seconds of startup time to allow.
A worker is unconditionally assumed to be alive
from the moment of its launch until \code{seconds_launch} seconds later.
After \code{seconds_launch} seconds, the worker is only
considered alive if it is actively connected to its assign websocket.}

\item{seconds_idle}{Maximum number of seconds that a worker can idle
since the completion of the last task. If exceeded, the worker exits.
But the timer does not launch until \code{tasks_timers} tasks
have completed.
See the \code{idletime} argument of \code{mirai::daemon()}. \code{crew} does not
excel with perfectly transient workers because it does not micromanage
the assignment of tasks to workers, so please allow enough idle
time for a new worker to be delegated a new task.}

\item{seconds_wall}{Soft wall time in seconds.
The timer does not launch until \code{tasks_timers} tasks
have completed.
See the \code{walltime} argument of \code{mirai::daemon()}.}

\item{tasks_max}{Maximum number of tasks that a worker will do before
exiting. See the \code{maxtasks} argument of \code{mirai::daemon()}.
\code{crew} does not
excel with perfectly transient workers because it does not micromanage
the assignment of tasks to workers, it is recommended to set
\code{tasks_max} to a value greater than 1.}

\item{tasks_timers}{Number of tasks to do before activating
the timers for \code{seconds_idle} and \code{seconds_wall}.
See the \code{timerstart} argument of \code{mirai::daemon()}.}

\item{reset_globals}{\code{TRUE} to reset global environment
variables between tasks, \code{FALSE} to leave them alone.}

\item{reset_packages}{\code{TRUE} to unload any packages loaded during
a task (runs between each task), \code{FALSE} to leave packages alone.}

\item{reset_options}{\code{TRUE} to reset global options to their original
state between each task, \code{FALSE} otherwise. It is recommended to
only set \code{reset_options = TRUE} if \code{reset_packages} is also \code{TRUE}
because packages sometimes rely on options they set at loading time.}

\item{garbage_collection}{\code{TRUE} to run garbage collection between
tasks, \code{FALSE} to skip.}

\item{launch_max}{Positive integer of length 1, maximum allowed
consecutive launch attempts which do not complete any tasks.
Enforced on a worker-by-worker basis.
The futile launch count resets to back 0
for each worker that completes a task.
It is recommended to set \code{launch_max} above 0
because sometimes workers are unproductive under perfectly ordinary
circumstances. But \code{launch_max} should still be small enough
to detect errors in the underlying platform.}

\item{tls}{A TLS configuration object from \code{\link[crew:crew_tls]{crew_tls()}}.}

\item{verbose}{Logical, whether to see console output and error messages
when submitting worker.}

\item{command_submit}{Character of length 1,
file path to the executable to submit a worker job.}

\item{command_terminate}{Character of length 1,
file path to the executable to terminate a worker job.
Set to \code{""} to skip manually terminating the worker.
Unless there is an issue with the platform,
the job should still exit thanks to the NNG-powered network programming
capabilities of \code{mirai}. Still, if you set \code{command_terminate = ""},
you are assuming extra responsibility for manually monitoring
your jobs on the cluster and manually terminating jobs as appropriate.}

\item{command_delete}{Deprecated on 2024-01-08 (version 0.1.4.9001).
Use \code{command_terminate} instead.}

\item{script_directory}{Character of length 1, directory path to the
job scripts. Just before each job submission, a job script
is created in this folder. Script base names are unique to each
launcher and worker, and the launcher deletes the script when the
worker is manually terminated. \code{tempdir()} is the default, but it
might not work for some systems.
\code{tools::R_user_dir("crew.cluster", which = "cache")}
is another reasonable choice.}

\item{script_lines}{Optional character vector of additional lines to be
added to the job script just after the more common flags.
An example would be \code{script_lines = "module load R"} if your cluster
supports R through an environment module.}

\item{lsf_cwd}{Character of length 1, directory to
launch the worker from (as opposed to
the system default). \code{lsf_cwd = "/home"} translates to a line of
\verb{#BSUB -cwd /home} in the LSF job script. \code{lsf_cwd = getwd()} is the
default, which launches workers from the current working directory.
Set \code{lsf_cwd = NULL} to omit this line from the job script.}

\item{lsf_log_output}{Character of length 1, file pattern to control
the locations of the LSF worker log files. By default, both standard
output and standard error go to the same file.
\code{lsf_log_output = "crew_log_\%J.log"} translates to a line of
\verb{#BSUB -o crew_log_\%J.log} in the LSF job script,
where \verb{\%J} is replaced by the job ID of the worker.
The default is \verb{/dev/null} to omit these logs.
Set \code{lsf_log_output = NULL} to omit this line from the job script.}

\item{lsf_log_error}{Character of length 1, file pattern for standard
error. \code{lsf_log_error = "crew_error_\%J.err"} translates to a line of
\verb{#BSUB -e crew_error_\%J.err} in the LSF job script,
where \verb{\%J} is replaced by the job ID of the worker.
The default is \verb{/dev/null} to omit these logs.
Set \code{lsf_log_error = NULL} to omit this line from the job script.}

\item{lsf_memory_gigabytes_limit}{Positive numeric of length 1
with the limit in gigabytes
\code{lsf_memory_gigabytes_limit = 4}
translates to a line of \verb{#BSUB -M 4G}
in the LSF job script.
\code{lsf_memory_gigabytes_limit = NULL} omits this line.}

\item{lsf_memory_gigabytes_required}{Positive numeric of length 1
with the memory requirement in gigabytes
\code{lsf_memory_gigabytes_required = 4}
translates to a line of \verb{#BSUB -R 'rusage[mem=4G]'}
in the LSF job script.
\code{lsf_memory_gigabytes_required = NULL} omits this line.}

\item{lsf_cores}{Optional positive integer of length 1,
number of CPU cores for the worker.
\code{lsf_cores = 4} translates
to a line of \verb{#BSUB -n 4} in the LSF job script.
\code{lsf_cores = NULL} omits this line.}
}
\description{
Create an \code{R6} object to launch and maintain
workers as LSF jobs.
}
\details{
WARNING: the \code{crew.cluster} LSF plugin is experimental.
Please proceed with caution and report bugs to
\url{https://github.com/wlandau/crew.cluster}.

To launch a LSF worker, this launcher
creates a temporary job script with a call to \code{crew::crew_worker()}
and submits it as an LSF job with \code{sbatch}. To see most of the lines
of the job script in advance, use the \code{script()} method of the launcher.
It has all the lines except for the job name and the
call to \code{crew::crew_worker()}, both of
which will be inserted at the last minute when it is time
to actually launch a worker.
}
\section{Attribution}{

The template files at
\url{https://github.com/mschubert/clustermq/tree/master/inst}
informed the development of the \code{crew} launcher plugins in
\code{crew.cluster}, and we would like to thank
Michael Schubert for developing \code{clustermq} and releasing it under
the permissive Apache License 2.0.
See the \code{NOTICE} and \code{README.md} files in the \code{crew.cluster}
source code for additional attribution.
}

\seealso{
Other lsf: 
\code{\link{crew_class_launcher_lsf}},
\code{\link{crew_controller_lsf}()}
}
\concept{lsf}
