% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdf_ranges.R
\name{pdf_ranges}
\alias{pdf_ranges}
\title{Calculate the climate tolerance of the taxa from their pdfs.}
\usage{
pdf_ranges(
  x,
  climate = x$parameters$climate,
  taxanames = x$input$taxa.name,
  uncertainties = x$parameters$uncertainties,
  orderby = NA
)
}
\arguments{
\item{x}{A \code{\link{crestObj}} generated by either the \code{\link{crest.calibrate}},
\code{\link{crest.reconstruct}} or \code{\link{crest}} functions.}

\item{climate}{Climate variables to be used to generate the plot. By default
all the variables are included.}

\item{taxanames}{A list of taxa to use for the plot (default is all the
recorded taxa).}

\item{uncertainties}{A (vector of) threshold value(s) indicating the error
bars that should be calculated (default are the values stored in x).}

\item{orderby}{A string ('name', or one of the climate variables) to sort
the output table}
}
\value{
The set of coordinates ext projected in equal earth.
}
\description{
Calculate the climate tolerance of the taxa from their pdfs.
}
\examples{

data(reconstr)
pdf_ranges(reconstr, climate='bio1')
pdf_ranges(reconstr, climate='bio12', orderby='bio1', uncertainties=c(0.2, 0.6, 0.95))

}
