#' Calculates how many species compose the response of each taxon.
#'
#' Calculates how many species compose the response of each taxon.
#'
#' @param x A \code{\link{crestObj}} generated by the
#'        \code{\link{crest.reconstruct}}, \code{\link{loo}} or
#'        \code{\link{crest}} functions.
#' @return Return the number of composing species of each taxon.
#' @export
#' @examples
#' data(reconstr)
#' getSpeciesdiversity(reconstr)

getSpeciesdiversity <- function(x) {
    if(base::missing(x)) x

    div <- rep(0, length(x$inputs$taxa.name))
    names(div) <- x$inputs$taxa.name

    for(tax in x$inputs$taxa.name) {
        if(is.list(x$modelling$pdfs[[tax]][[1]])) {
           div[tax] <- length(x$modelling$pdfs[[tax]][[1]]$pdfsp)
        }
    }

    div <- sort(div)
    div
}
