% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cj_df.R
\name{cj_df}
\alias{cj_df}
\alias{cj_df.data.frame}
\alias{[.cj_df}
\title{Create a \dQuote{cj_df} data frame}
\usage{
cj_df(x)

\method{cj_df}{data.frame}(x)

\method{[}{cj_df}(x, i, j, drop = FALSE)
}
\arguments{
\item{x}{A data frame}

\item{i}{See \code{\link{[.data.frame}}}

\item{j}{See \code{\link{[.data.frame}}}

\item{drop}{See \code{\link{[.data.frame}}}
}
\value{
An data frame with additional \dQuote{cj_df} class, which has subsetting methods that preserve variables attributes.
}
\description{
A simple data frame extension that preserves attributes during subsetting operations.
}
\examples{
x1 <- data.frame(a = 1:3, b = 4:6)
attr(x1$a, "label") <- "Variable A"

# cj_df() returns a data frame
inherits(x1, "data.frame")
class(x1)

# attributes dropped for data frames
attr(x1[1:2,]$a, "label")

# attributes preserved with a cj_df
attr(cj_df(x1)[1:2,]$a, "label")

}
