% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_training.R
\name{train_lr}
\alias{train_lr}
\title{Trainig LR model}
\usage{
train_lr(dat_train, dat_test = NULL, target, x_list = NULL,
  occur_time = NULL, prop = 0.7, tree_control = list(p = 0.02, cp =
  0.00000001, xval = 5, maxdepth = 10), bins_control = list(bins_num =
  10, bins_pct = 0.05, b_chi = 0.02, b_odds = 0.1, b_psi = 0.03, b_or =
  0.15, mono = 0.2, odds_psi = 0.15, kc = 1), thresholds = list(cor_p =
  0.8, iv_i = 0.02, psi_i = 0.1, cos_i = 0.6), lasso = TRUE,
  step_wise = TRUE, best_lambda = "lambda.auc", seed = 1234, ...)
}
\arguments{
\item{dat_train}{data.frame of train data. Default is NULL.}

\item{dat_test}{data.frame of test data. Default is NULL.}

\item{target}{name of target variable.}

\item{x_list}{names of independent variables. Default is NULL.}

\item{occur_time}{The name of the variable that represents the time at which each observation takes place.Default is NULL.}

\item{prop}{Percentage of train-data after the partition. Default: 0.7.}

\item{tree_control}{the list of parameters to control cutting initial breaks by decision tree. See details at: \code{\link{get_tree_breaks}}}

\item{bins_control}{the list of parameters to control merging initial breaks. See details at: \code{\link{select_best_breaks}},\code{\link{select_best_class}}}

\item{thresholds}{Thresholds for selecting variables.
\itemize{
  \item \code{cor_p} The maximum threshold of correlation. Default: 0.8.
  \item \code{iv_i} The minimum threshold of IV. 0.01 to 0.1 usually work. Default: 0.02
  \item \code{psi_i} The maximum threshold of PSI. 0.1 to 0.3 usually work. Default: 0.1.
  \item \code{cos_i} cos_similarity of posive rate of train and test. 0.7 to 0.9 usually work.Default: 0.5.
}}

\item{lasso}{Logical, if TRUE, variables filtering by LASSO. Default is TRUE.}

\item{step_wise}{Logical, stepwise method. Default is TRUE.}

\item{best_lambda}{Metheds of best lanmbda stardards using to filter variables by LASSO. There are 3 methods: ("lambda.auc", "lambda.ks", "lambda.sim_sign") . Default is  "lambda.auc".}

\item{seed}{Random number seed. Default is 1234.}

\item{...}{Other parameters}
}
\description{
\code{train_lr} is for training the logistic regression model using in \code{\link{training_model}}.
}
