% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_visualization.R
\name{ks_value}
\alias{ks_value}
\title{ks_value}
\usage{
ks_value(dat_pred = NULL, target = NULL, score = NULL, g = 20,
  breaks = NULL)
}
\arguments{
\item{dat_pred}{A data frame with predict prob or score.}

\item{target}{The name of target variable.}

\item{score}{The name of prob or score variable.}

\item{g}{Number of breaks for prob or score.}

\item{breaks}{Splitting points of prob or score.}
}
\description{
\code{ks_value} is for get plots for a  variable.
}
\examples{
sub = cv_split(UCICreditCard, k = 30)[[1]]
dat = UCICreditCard[sub,]
dat = re_name(dat, "default.payment.next.month", "target")
dat = data_cleansing(dat, target = "target", obs_id = "ID",
occur_time = "apply_date", miss_values = list("", -1))

train_test <- train_test_split(dat, split_type = "OOT", prop = 0.7,
                                occur_time = "apply_date")
dat_train = train_test$train
dat_test = train_test$test
x_list = c("PAY_0", "LIMIT_BAL", "PAY_AMT5", "PAY_3", "PAY_2")
Formula = as.formula(paste("target", paste(x_list, collapse = ' + '), sep = ' ~ '))
set.seed(46)
lr_model = glm(Formula, data = dat_train[, c("target", x_list)], family = binomial(logit))

dat_train$pred_LR = round(predict(lr_model, dat_train[, x_list], type = "response"), 5)
dat_test$pred_LR = round(predict(lr_model, dat_test[, x_list], type = "response"), 5)
ks_value(dat_pred = dat_train,
target = "target", score ="pred_LR", g = 20)
}
