% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsplines.R
\name{bsplines}
\alias{bsplines}
\title{B-Splines}
\usage{
bsplines(x, iknots = NULL, df = NULL, bknots = range(x), order = 4L)
}
\arguments{
\item{x}{a numeric vector}

\item{iknots}{internal knots}

\item{df}{degrees of freedom: sum of the order and internal knots.  Ignored
if \code{iknots} is specified.}

\item{bknots}{boundary knot locations, defaults to \code{range(x)}.}

\item{order}{order of the piecewise polynomials, defaults to 4L.}
}
\description{
An implementation of Carl de Boor's recursive algorithm for building
B-splines.
}
\details{
The difference between this function and \code{splines::bs} come in the
attributes associated with the output and default options.  The
\code{cpr::bsplines} call is intended to simplify the work needed with
respect to the control polygon reduction.  Further, the implementation of
\code{cpr::bsplines} is in C++ and tends to be faster than
\code{splines::bs}.

See the \code{vignette("cpr-pkg", package = "cpr")} for a detailed
comparison between the \code{bsplines} and \code{\link[splines]{bs}} calls.
}
\examples{
# build a vector of values to transform
xvec <- seq(-3, 5, length = 100)

# cubic b-spline
bmat <- bsplines(xvec, iknots = c(-2, 0, 0.2))
bmat

# plot the splines
plot(bmat)

# If you want a second x-axis to show the x-values try the following:
second_x_axis <- round(stats::quantile(xvec, probs = seq(0, 1, by = .2)), 2)

plot(bmat) +
ggplot2::annotate(geom = "text", x = second_x_axis, y = -0.02, label = second_x_axis) +
ggplot2::annotate(geom = "linerange", x = second_x_axis, ymin = -0.05, ymax = -0.04) +
ggplot2::coord_cartesian(ylim = c(0, 1))

# quadratic splines
bmat <- bsplines(xvec, iknots = c(-2, 0, 0.2), order = 3L)
bmat
plot(bmat) + ggplot2::ggtitle("Quadratic B-splines")
}
\references{
C. de Boor, "A practical guide to splines. Revised Edition," Springer, 2001.

H. Prautzsch, W. Boehm, M. Paluszny, "Bezier and B-spline Techniques," Springer, 2002.
}
\seealso{
\code{\link{plot.cpr_bs}} for plotting the basis,
\code{\link{bsplineD}} for building the basis matrices for the first and
second derivative of a B-spline.

See \code{\link{update_bsplines}} for info on a tool for updating a
\code{cpr_bs} object.  This is a similar method to the
\code{\link[stats]{update}} function from the \code{stats} package.
}
\author{
Peter DeWitt \email{dewittpe@gmail.com}
}
